//    HttpConnectionGPL.h
/* 
   Copyright (c) 1993-1999 Tumbleweed Software Corp.
*/
//    This HttpConnection_stub library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
// $Id: HttpConnection_stub.h,v 1.5 1999/05/04 02:17:00 edumas Exp $
// 

#ifndef HttpConnection_DummyStub_H
#define HttpConnection_DummyStub_H

#ifndef HttpConnectionInterface_h
#include <HttpConnection.h>
#endif

class HTTPCONNECTION_LIB_DECL HttpConnection_stub: public HttpConnectionInterfaceI
{
 protected:
	HttpConnection_stub(const char *host, 
			    unsigned int port = 80)
	    :
	    HttpConnectionInterfaceI(host,port){};

  public:
	virtual ~HttpConnection_stub() {};

	virtual HTTPReturnValueT SetHeader(const char *header, const char *value){ return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }
	virtual HTTPReturnValueT SetHeaderContentLength(unsigned int sz){ return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }
	virtual HTTPReturnValueT SetHeaderContentType(const char *mimetype){ return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }
	virtual HTTPReturnValueT SendRequestHeader(const char *path, HttpMethodT method)= 0;
	virtual HTTPReturnValueT BeginBodyOutput(){ return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }
	virtual HTTPReturnValueT WriteBodyOutput(const char *buf, unsigned int sz, unsigned int &sz_write){ return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }
	virtual HTTPReturnValueT EndBodyOutput(){ return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }
	virtual HTTPReturnValueT ReceiveResponseHeader(){ return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }
	virtual char  		  	 *GetHeader(const char *header) {return NULL; }
	virtual unsigned int 	  GetHeaderContentLength() {return 0; }
	virtual HTTPReturnValueT BeginBodyInput() { return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }
	virtual HTTPReturnValueT ReadBodyInput(char *buf, unsigned int sz, unsigned int &sz_read) { return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }
	virtual HTTPReturnValueT EndBodyInput() { return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED; }	

	virtual char *EncodeBase64(const char *s)  { return NULL;  }
        virtual char *UnEncodeBase64(const char *s) { return NULL;  }

};

class HTTPCONNECTION_LIB_DECL HttpStubDummyC : public HttpConnectionInterfaceFactoryC {
 public:
    HttpStubDummyC(){};
    virtual ~HttpStubDummyC() {};

    virtual HttpConnectionInterfaceI *CreateHttpConnection(
		const char *host, 
		unsigned int port = 80
	);
};
#endif
