#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################
SUBDIRS=sharedlib

DIR_CPPFLAGS = -I$(TOP)/../HttpConnection/Include -I../.. $(patsubst %,-I%/../..,$(VPATH))
DIR_CPPFLAGS += $(CORBA_CPPFLAGS)

CXXSRCS = HttpConnectionGPL.cc

CXXOBJS = HttpConnectionGPL.o

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

lib = $(patsubst %,$(LibPattern),PostaOptHttpConnectionRt)

CXXOPTIONS  = $(MSVC_CXXNODEBUGFLAGS)
CXXLINKOPTIONS = $(MSVC_CXXLINKNODEBUGOPTIONS)

else

#############################################################################
#   Make variables for non-Win32 platforms                                  #
#############################################################################

lib = $(patsubst %,$(LibPattern),optHttpConnection)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

all:: $(lib)

all::
	@$(MakeSubdirs)

$(lib): $(CXXOBJS)
	@$(StaticLinkLibrary)

clean::
	$(RM) $(lib)

export:: $(lib)
	@$(ExportLibrary)

export::
	@$(MakeSubdirs)



