//    HttpConnectionGPL.h
/* 
   Copyright (c) 1993-1999 Tumbleweed Software Corp.
*/
//    This GPLHTTPConnection library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
// $Id: HttpConnectionGPL.cc,v 1.3 1999/05/19 21:15:36 edumas Exp $
// 

/* 
   IMPORTANT: this code implement the HTTP/1.0 client side. This code
   good really be improved (HTTP/1.1, non blocking sockets,...) or use
   for example the wwwlib from the W3C (http://www.w3c.org).  

   This is code is mostly an example of the use of the HttpConnectionI
   interface.

   This code is not the code we using in the real life.  
*/
#include <sys/types.h>
#include <sys/socket.h>
#include <assert.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>

#include <HttpConnection.h>
#include <HttpConnectionGPL.h>

#include <omniORB2/CORBA.h>

#define CRLF "\r\n"
#define MAX_HEADER_SIZE 16

/* HttpConnection Factory */
HttpConnectionInterfaceFactoryC *HttpConnectionInterfaceFactoryC::m_ptr = NULL;

#ifdef HAS_SSL
HttpConnectionInterfaceI *
GPLHTTPConnectionFactoryC::CreateHttpConnection(const char   *host, 
						unsigned int  port,
						unsigned char ssl,
						const char    *rootCertificates,
						SSLConnectionInterfaceI::ProtocolVersionT ssl_version,
						SSLCipherManagerInterfaceI::SSLCipherT *cipher_array,
						unsigned int num_cipers)
{	
  if (ssl == true) {
    return new GPLHTTPConnectionC(host, port, true,
				  rootCertificates, ssl_version, 
				  cipher_array, num_cipers);
  }
  return new GPLHTTPConnectionC(host, port);	
}
#else
HttpConnectionInterfaceI *
GPLHTTPConnectionFactoryC::CreateHttpConnection(const char *host, 
						unsigned int port)
{
  return new GPLHTTPConnectionC(host, port);
}
#endif

HttpConnectionInterfaceFactoryC *GetHttpConnectionInterfaceManager()
{
  if (HttpConnectionInterfaceFactoryC::m_ptr == NULL) {
    HttpConnectionInterfaceFactoryC::m_ptr = new GPLHTTPConnectionFactoryC();
  }
  return HttpConnectionInterfaceFactoryC::m_ptr;
}

/*********************************************************************
 *    
 * HttpConnectionInterfaceI : destructor.
 *
 *********************************************************************/
HttpConnectionInterfaceI::~HttpConnectionInterfaceI()
{
}


/*********************************************************************
 *    
 * HttpConnection : GPL skeleton Implementation of this class.
 *
 *********************************************************************/
#ifdef HAS_SSL
GPLHTTPConnectionC::GPLHTTPConnectionC(const char *host, 
				       unsigned int port,
				       unsigned char ssl,
				       const char *rootCertificates,
				       SSLConnectionInterfaceI::ProtocolVersionT ssl_version,
				       SSLCipherManagerInterfaceI::SSLCipherT *cipher_array,
				       unsigned int num_cipers)
    :
  HttpConnectionInterfaceI(host,port,ssl,rootCertificates,ssl_version,cipher_array,num_cipers),
  m_fd_socket(0),
  m_port(port),
  m_array_header(NULL),
  m_array_size(0),
  m_state(NOT_CONNECTED)
{
  m_host = CORBA::string_dup(host);

  m_array_header = new struct header_s [MAX_HEADER_SIZE];
  memset(m_array_header, 0, sizeof(struct header_s) * MAX_HEADER_SIZE);
}
#else
GPLHTTPConnectionC::GPLHTTPConnectionC(const char *host, 
				       unsigned int port)
    :
  HttpConnectionInterfaceI(host,port),
  m_fd_socket(0),
  m_port(port),
  m_array_header(NULL),
  m_array_size(0),
  m_state(NOT_CONNECTED)
{
  m_host = CORBA::string_dup(host);
  
  m_array_header = new struct header_s [MAX_HEADER_SIZE];
  memset(m_array_header, 0, sizeof(struct header_s) * MAX_HEADER_SIZE);

}
#endif

GPLHTTPConnectionC::~GPLHTTPConnectionC()
{
  delete [] m_host;
  if (m_fd_socket) {
    close(m_fd_socket);    
  }

  if ((m_array_size) && (m_array_header != NULL)) {
    for (int i = 0 ; i<m_array_size ; ++i) {
      delete []m_array_header[i].header;
      delete []m_array_header[i].data;
    }
    delete []m_array_header;
  }
}

HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::SetHeader(const char *header, 
			      const char *value)
{
  assert(header != NULL);
  assert(value  != NULL);
  assert(m_state == NOT_CONNECTED);

  // Try to see if the field has already been set, and update it
  for (int i=0 ; i < m_array_size ; ++i) {
    if (!strcasecmp(m_array_header[i].header, header)) {
      delete m_array_header[i].data;
      m_array_header[i].data = CORBA::string_dup(value);
      return HttpConnectionInterfaceI::HTTP_RETURN_OK;
    }
  }
  m_array_header[m_array_size].header = CORBA::string_dup(header);
  m_array_header[m_array_size].data = CORBA::string_dup(value);
  m_array_size++;
  
  // Add the field in the array
  return HttpConnectionInterfaceI::HTTP_RETURN_OK;
}

HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::SetHeaderContentLength(unsigned int sz)
{
  assert(sz != 0);
  assert(m_state == NOT_CONNECTED);
  char buf[16];
  
  sprintf(buf, "%d",sz);

  return SetHeader("Content-Length", buf);
}

HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::SetHeaderContentType(const char *mimetype)
{
  assert(mimetype != NULL);
  assert(m_state == NOT_CONNECTED);

 return SetHeader("Content-Type", mimetype);
}


// We only implement the GET and POST methods currently.	
HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::SendRequestHeader(const char *path, 
				      HttpConnectionInterfaceI::HttpMethodT method)
{
  assert(path != NULL);
  assert(m_state == NOT_CONNECTED);

  // Connect now.
  struct sockaddr_in myaddr;
  bzero(&myaddr, sizeof(myaddr));
  
  myaddr.sin_family      = AF_INET;
  myaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  myaddr.sin_port        = htons(m_port);

  struct hostent *he = gethostbyname(m_host);
  memcpy (&myaddr.sin_addr, he->h_addr_list[0], he->h_length);
  /* Open the connection to the socket - standard blocking socket. */
  if ((m_fd_socket = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
    perror("socket");
    return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_BAD_VALUE;
  }
  if (connect(m_fd_socket, (struct sockaddr *) &myaddr, sizeof(myaddr)) == -1) {
    perror("connect");

    close(m_fd_socket);
    m_fd_socket = 0;
    return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_BAD_VALUE;
  }

  char line[256];
  // Send the Method
  switch(method) 
    {
    case HttpConnectionInterfaceI::HTTP_METHOD_GET:
      sprintf(line,"GET %s HTTP/1.0 %s",
	      path, CRLF);
      break;

    case HttpConnectionInterfaceI::HTTP_METHOD_POST:	
      sprintf(line,"POST %s HTTP/1.0 %s",
	      path, CRLF);
      break;

    default:
      return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_NOT_IMPLEMENTED;
    }
  
  write(m_fd_socket, line, strlen(line));
  
  for (int i=0 ; i < m_array_size ; ++i) {
    sprintf(line, "%s: %s%s",
	    m_array_header[i].header,
	    m_array_header[i].data,
	    CRLF);
    write(m_fd_socket, line, strlen(line));
  }

  // Body Separator
  write(m_fd_socket, CRLF, strlen(CRLF));
  if (method == HttpConnectionInterfaceI::HTTP_METHOD_GET) {
    m_state = BODY_OUTPUT_SENT;
  } else {
    m_state = HEADER_SENT;
  }
    
  return HttpConnectionInterfaceI::HTTP_RETURN_OK;
}
	
HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::BeginBodyOutput()
{
  assert(m_state == HEADER_SENT);
  m_state = BODY_OUTPUT;
  
  return HttpConnectionInterfaceI::HTTP_RETURN_OK;
}

HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::WriteBodyOutput(const char *buf, 
				    unsigned int sz,
				    unsigned int &sz_write)
{
  assert(m_state == BODY_OUTPUT);
  int ret;
  
  if ((ret = write(m_fd_socket, buf, sz)) == -1) {
    return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_BAD_VALUE;
  }
  sz_write = ret;
  
  return HttpConnectionInterfaceI::HTTP_RETURN_OK;
}

HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::EndBodyOutput()
{
  assert(m_state == BODY_OUTPUT);
  m_state = BODY_OUTPUT_SENT;  
  return HttpConnectionInterfaceI::HTTP_RETURN_OK;
}


HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::ReceiveResponseHeader()
{
  assert(m_state == BODY_OUTPUT_SENT);
  m_state = HEADER_RECEIVED;

  // Cleanup the array_header.
  for (int i = 0 ; i<m_array_size ; ++i) {
    delete []m_array_header[i].header;
    delete []m_array_header[i].data;
  }
  m_array_size=0;
  
  HttpConnectionInterfaceI::HTTPReturnValueT response_status = HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_BAD_VALUE;
  char first_line = 1;
  
  while(1) {
    char line[128];
    memset(line, 128, 0);
    
    int i=0;
    char last_char = 0;
    char current_char = 0;
    while (1) {
      if (read(m_fd_socket, &current_char, sizeof(char)) <= 0) {
	break;
      }
      if ((last_char == '\r')||(current_char == '\n')) {
	// Remove the last \r ==> useless.
	line[i-1]=0;
	break;
      }
      line[i++] = current_char;
      last_char = current_char;
    }
    
    // End of header.
    if (i<=1) {
      break;
    }
    
    if (first_line) { // Parse the status code.
      // HTTP/1.x CDE msg
      if (strncmp(line, "HTTP/",strlen("HTTP/"))) {
	return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_BAD_VALUE;
      }
      int i=0;
      // Jump to the the returned code!
      while (line[i++] != ' ') {
	if (line[i] == '\0') {
	  return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_BAD_VALUE;
	}
      }
      int ret_code = (line[i++]-'0')*100;
      ret_code += (line[i++]-'0')*10;
      ret_code += line[i++]-'0';
      response_status = (HttpConnectionInterfaceI::HTTPReturnValueT)ret_code;
      first_line--;
    } else {
      // Look for the : separator
      char *separator = strchr(line, ':');
      if (separator == NULL) {
	return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_BAD_VALUE;
      }
      
      char header[128];
      char value[128];
      strncpy(header, line, separator - line);
      header[separator - line] = 0;
      // Get rid of the ": " 
      strncpy(value, &separator[2], strlen(line) - (separator - line + 2));
      value[strlen(line) - (separator - line + 2)]=0;
      
      m_array_header[m_array_size].header = CORBA::string_dup(header);
      m_array_header[m_array_size].data   = CORBA::string_dup(value);
      m_array_size++;

      // add it in the m_array_header
    }
  } /* End of while */
  
  return response_status;
}

char *
GPLHTTPConnectionC::GetHeader(const char *header)
{
  assert(header != NULL);
  assert(m_state ==  HEADER_RECEIVED);
  
  if ((!m_array_size) || (m_array_header == NULL))
    return NULL;

  for (int i=0 ; i < m_array_size ; ++i) {
    
    if (!strcasecmp(m_array_header[i].header, header)) {
      return CORBA::string_dup(m_array_header[i].data);
    }
  }
  
  return NULL; 
} 

unsigned int
GPLHTTPConnectionC::GetHeaderContentLength()
{
  assert(m_state ==  HEADER_RECEIVED);

  char *content = GetHeader("Content-length");

  if (content==NULL) {
    return 0;
  }
  
  unsigned int val = atoi(content);
  delete []content;

  return val;
}
	
HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::BeginBodyInput()
{
  assert(m_state ==  HEADER_RECEIVED);
  m_state = BODY_INPUT;
  
  return HttpConnectionInterfaceI::HTTP_RETURN_OK;
}

HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::ReadBodyInput(char *buf, 
				  unsigned int sz,
				  unsigned int &sz_read)
{
  assert(buf != NULL);
  assert(m_state ==  BODY_INPUT);
  
  int ret;
  
  if ((ret = read(m_fd_socket, buf, sz)) == -1) {
    return HttpConnectionInterfaceI::HTTP_RETURN_CONNECTION_BAD_VALUE;
  }
  sz_read = ret;
  
  return HttpConnectionInterfaceI::HTTP_RETURN_OK;
}

HttpConnectionInterfaceI::HTTPReturnValueT
GPLHTTPConnectionC::EndBodyInput()
{
  assert(m_state ==  BODY_INPUT);
  m_state = BODY_INPUT_RECEIVED;
  
  close(m_fd_socket);
  m_fd_socket = -1;
  // Cleanup the array_header.
  for (int i = 0 ; i<m_array_size ; ++i) {
    delete []m_array_header[i].header;
    delete []m_array_header[i].data;
  }
  m_array_size=0;

  m_state = NOT_CONNECTED;
  
  return HttpConnectionInterfaceI::HTTP_RETURN_OK;
}

static char hexatable[64] = {
    'A','B','C','D','E','F','G','H','I','J','K','L','M',
    'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
    'a','b','c','d','e','f','g','h','i','j','k','l','m',
    'n','o','p','q','r','s','t','u','v','w','x','y','z',
    '0','1','2','3','4','5','6','7','8','9','+','/'
};

/* Encode the string - origin : metamail, mutt, etc. */
char*
GPLHTTPConnectionC::EncodeBase64(const char *s)
{
  assert( s != NULL);

  char *output_buffer = NULL;
  char *input_buffer  = (char *)s;
  
  // Approximation of the final length
  unsigned int  len_input = strlen(s);
  unsigned int  len_output = 4*(((len_input+2)/3)+1);
  
  output_buffer = new char[len_output];
  memset(output_buffer, 0, len_output);
  
  char *output_buffer_ptr = output_buffer;
  
  unsigned int i;

  // Scan the string and perform the encoding.
  for (i=0 ; i<len_input ; i += 3) {
    *(output_buffer++) = hexatable[*input_buffer >> 2];            /* c1 */
    *(output_buffer++) = hexatable[((*input_buffer << 4) & 060) | ((input_buffer[1] >> 4) & 017)]; /*c2*/
    *(output_buffer++) = hexatable[((input_buffer[1] << 2) & 074) | ((input_buffer[2] >> 6) & 03)];/*c3*/
    *(output_buffer++) = hexatable[input_buffer[2] & 077];         /* c4 */
    
    input_buffer += 3;
  }

  /* Adjust the end */
  if (i == len_input + 1) {
    /* There were only 2 bytes in that last group */
    output_buffer[-1] = '=';
  } else if(i == len_input + 2) {
    /* There was only 1 byte in that last group */
    output_buffer[-1] = '=';
    output_buffer[-2] = '=';
  }
  *output_buffer = '\0';
  
  // Resize and return only what is necessary
  char *real_output = new char[strlen(output_buffer_ptr) + 1];
  strcpy(real_output, output_buffer_ptr);
  delete []output_buffer_ptr;
  
  return real_output;
}

/*
  And decode it - This method is not implemented because we do not use it ;-).
  Feel free to add the implementation
*/

char*
GPLHTTPConnectionC::UnEncodeBase64(const char *s)
{
  assert(s!=NULL);

  return NULL;
}

