//
//    Copyright (C)  1993-1999 Tumbleweed Software Corp.
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
// $Workfile: $
//
// Description:
//    
//    Ip Mapping file management.
//
//     $Log: ip_mapping_file.h,v $
//     Revision 1.7  1999/05/19 15:52:40  edumas
//     	GPL licence.
//
//     Revision 1.6  1999/03/26 19:50:05  edumas
//     	Build Fix.
//
//     Revision 1.5  1999/03/25 01:59:55  edumas
//     	First set of Randy's code review modifications:
//     	- some comments added,
//     	- delete_data() moved as private,
//     	- remove of cursors
//     	- pd_ for private members.
//
//     Revision 1.4  1999/02/16 01:07:30  edumas
//         Add new method.
//
//     Revision 1.3  1999/02/12 03:36:59  edumas
//           IP_Mapping working.
//
//     Revision 1.2  1999/02/11 02:38:19  edumas
//         Comments updated.
//
//     Revision 1.1  1999/02/11 02:32:15  edumas
//         Add the ip_mapping feature.
//
//
// $Id: ip_mapping_file.h,v 1.7 1999/05/19 15:52:40 edumas Exp $
//
// Add new header
//
// $NoKeywords: $
//
#ifndef IP_MAPPING_FILE_H
#define IP_MAPPING_FILE_H

#ifndef IOP_HTTP_EXTERNAL_H
#include <IOP_HTTP/IOP_HTTP_external.h>
#endif

/* Example of text File format read:

#
# IP adress     Web site    HTTP HTTPS  Path   Mime-Type          SSLStatus
#
192.240.*.*    www.posta.com 80   443  /ellis  x-application/ellis   1
65.*.*.*       www.posta.com 80   443  /ellis  x-application/ellis   1
65.*.*.*       www.posta.com 81   446  /ellis  x-application/ellis   1
147.210.53.433 www.ups.com   81   456  /ellis  x-application/ellis   4
*/

typedef struct ip_file_mapping_s *ip_file_mapping_t;

class ip_mapping_file {

 public:
  ip_mapping_file();

  /* The file is not read before load_file() is called. */
  ip_mapping_file(const char *filename_to_load);
  
  ~ip_mapping_file();

  /* Load the file and return the number of items read.  If no
     parameter is given and a filename as already been via the
     constructor or via a previous load_file() call, data are
     re-read. Return 0 if any error occurs.  */
  unsigned int load_file(const char *filename_to_load = NULL);
  
  /*
    Recognize patterns for IP addresses:
    
    (192.2.3.4,   147.2.3.3 )  => false
    (192.*.34.12, 192.34.3.3)  => false
    (192.*.34.*,  192.2.34.3)  => true
    (192.34.12.*, 192.34.12.3) => true
    (192.34.*.*,  192.34.12.3) => true
    (192.*.*.*,   192.34.12.3) => true

    Notes: 
    1- it returns the first match found.
    2- the ip address the user specify has to be a real IP address
    (not a mask), following the standard notation a.b.c.d
  */
  const ip_file_mapping_t ip_match(const char *ip);
  
  /* Access methods */
  const char   *get_ip         (ip_file_mapping_t ipf);
  const char   *get_host       (ip_file_mapping_t ipf);
  unsigned int  get_port_http  (ip_file_mapping_t ipf);
  unsigned int  get_port_https (ip_file_mapping_t ipf);
  const char   *get_pathname   (ip_file_mapping_t ipf);
  const char   *get_mimetype   (ip_file_mapping_t ipf);
  SSL_State     get_ssl_policy (ip_file_mapping_t ipf);

  /* Is mapping file usable ? */
  unsigned char is_mapping_feature(); 

 private:
  void         delete_data();
  unsigned int read_digit(const char *ptr, size_t *start);
  char        *read_word(const char *ptr, size_t *start);
  void         delete_data_recursive(ip_file_mapping_t ipmap);
  
  ip_file_mapping_t pd_ip_file_data;
  char             *pd_filename;
};

#endif
