//
//    Copyright (C)  1993-1999 Tumbleweed Software Corp.
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
// $Workfile: $
//
// Description:
//    
//    Protocol Handshake.
//
//     $Log: IOP_HTTP_handshake.h,v $
//     Revision 1.6  1999/05/19 15:52:40  edumas
//     	GPL licence.
//
//     Revision 1.5  1999/04/02 22:16:35  edumas
//     	Fix dependency.
//
//     Revision 1.4  1999/03/26 01:34:18  edumas
//     	Comments update.
//
//     Revision 1.3  1999/03/25 00:07:41  edumas
//     	Apply Randy's comments.
//
//     Revision 1.2  1999/03/10 00:49:23  edumas
//     	Handshaking is now done in a portable way.
//
//     Revision 1.1  1999/02/10 01:54:22  edumas
//         External interfaces for IOP_HTTP.
//
//
//
// $Id: IOP_HTTP_handshake.h,v 1.6 1999/05/19 15:52:40 edumas Exp $
//
// Add new header
//
// $NoKeywords: $
//
#ifndef IOP_HTTP_HANDSHAKE_H
#define IOP_HTTP_HANDSHAKE_H

#ifndef __CORBA_H__
#include <omniORB2/CORBA.h>
#endif

#define IOP_HTTP_MAGIC_HANDSHAKE   0x11101972
#define IOP_HTTP_PROTOCOL_VERSION  0x01

/* 
   This structure is the first data to send to the Web server from the
   ORB.  It is going to identify which host and which port data have
   to sent to. 

   If the "magic" structure field does not match, the "caller" is not
   identified and the request must be rejected on the web server.
*/

struct iop_http_handshake {
	CORBA::ULong  pd_magic;          /* Magic number */
	CORBA::UShort pd_version_proto;  /* Protocol version Id. */

	CORBA::Char   pd_hostname[128];  /* hostname to connect on the server
									  network.  MAXHOSTNAMELEN is not
									  used because its value is not
									  standard.  */

	CORBA::UShort pd_port;           /* port to connect on the server
									  network */
};

#endif

