#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################
SUBDIRS=sharedlib

DIR_CPPFLAGS = -I$(TOP)/../HttpConnection/Include -I../.. $(patsubst %,-I%/../..,$(VPATH))
DIR_CPPFLAGS += $(CORBA_CPPFLAGS)

CXXSRCS = HttpConnection_stub.cc
CXXOBJS = HttpConnection_stub.o

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

ifndef BuildWin32DebugLibraries

lib = $(patsubst %,$(LibPattern),HttpConnection_stubRt)

CXXOPTIONS  = $(MSVC_CXXNODEBUGFLAGS)
CXXLINKOPTIONS = $(MSVC_CXXLINKNODEBUGOPTIONS)

else

# Building the debug version of the library in the debug subdirectory.
# Notice that this dir.mk is recursively used in the debug directory to build
# this library. The BuildWin32DebugLibraries make variable is set to 1 in
# the dir.mk generated in the debug directory.
#

lib = $(patsubst %,$(LibDebugPattern),HttpConnection_stubRt)

CXXDEBUGFLAGS = 
CXXOPTIONS  = $(MSVC_CXXDEBUGFLAGS)
CXXLINKOPTIONS = $(MSVC_CXXLINKDEBUGOPTIONS)

endif

else

#############################################################################
#   Make variables for non-Win32 platforms                                  #
#############################################################################

lib = $(patsubst %,$(LibPattern),HttpConnection_stub)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

all:: $(lib)

all::
	@$(MakeSubdirs)

$(lib): $(CXXOBJS)
	@$(StaticLinkLibrary)

clean::
	$(RM) $(lib)

export:: $(lib)
	@$(ExportLibrary)

export::
	@$(MakeSubdirs)



