//    HttpConnectionGPL.h
/* 
   Copyright (c) 1993-1999 Tumbleweed Software Corp.
*/
//    This opHttpConnection library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
// $Id: HttpConnectionGPL.h,v 1.3 1999/05/19 21:15:36 edumas Exp $
// 

#ifndef HttpConnectionGPL_H
#define HttpConnectionGPL_H

#ifndef HttpConnectionInterface_h
#include <HttpConnection.h>
#endif

class HTTPCONNECTION_LIB_DECL GPLHTTPConnectionC  : public  HttpConnectionInterfaceI
{
 public:
#ifdef HAS_SSL
    GPLHTTPConnectionC(const char  *host, 
		       unsigned int port = 80,
		       unsigned char ssl=false,
		       const char    *rootCertificates = NULL,
		       SSLConnectionInterfaceI::ProtocolVersionT ssl_version = SSLConnectionInterfaceI::TK_SSL_Version_2_0,
		       SSLCipherManagerInterfaceI::SSLCipherT *cipher_array = NULL,
		       unsigned int num_cipers = 0);
#else
    GPLHTTPConnectionC(const char  *host, 
		       unsigned int port = 80);
#endif
  
    virtual ~GPLHTTPConnectionC();
    HTTPReturnValueT SetHeader(const char *header, 
			       const char *value);
    HTTPReturnValueT SetHeaderContentLength(unsigned int sz);
    HTTPReturnValueT SetHeaderContentType(const char *mimetype);
  
    HTTPReturnValueT SendRequestHeader(const char *path, HttpMethodT method = HTTP_METHOD_GET);
  
    HTTPReturnValueT BeginBodyOutput();
    HTTPReturnValueT WriteBodyOutput(const char *buf, 
				     unsigned int sz,
				     unsigned int &sz_write);
    HTTPReturnValueT EndBodyOutput();
        
    HTTPReturnValueT ReceiveResponseHeader();

    char            *GetHeader(const char *header);
    unsigned int GetHeaderContentLength();
        
    HTTPReturnValueT BeginBodyInput();
    HTTPReturnValueT ReadBodyInput(char *buf, 
				   unsigned int sz,
				   unsigned int &sz_read);
    HTTPReturnValueT EndBodyInput();

    /* Base 64 Encoding/Unencoding */
    char *EncodeBase64(const char *s);
    char *UnEncodeBase64(const char *s);
 private:
    int m_fd_socket;
    char *m_host;
    unsigned int m_port;

    
    struct header_s {
      char *header;
      char *data;
    };
    struct header_s *m_array_header;
    int m_array_size;
    
    enum StateConnectionT {
      NOT_CONNECTED,
      HEADER_SENT,
      BODY_OUTPUT,
      BODY_OUTPUT_SENT,
      HEADER_RECEIVED,
      BODY_INPUT,
      BODY_INPUT_RECEIVED
    };
    
    StateConnectionT m_state;
};

class GPLHTTPConnectionFactoryC : public HttpConnectionInterfaceFactoryC {
 public:
    GPLHTTPConnectionFactoryC(){};
    virtual ~GPLHTTPConnectionFactoryC() {};

#ifdef HAS_SSL
    HttpConnectionInterfaceI *CreateHttpConnection(const char   *host, 
						   unsigned int  port = 80,
						   unsigned char ssl = false,
						   const char   *rootCertificates = NULL,
						   SSLConnectionInterfaceI::ProtocolVersionT ssl_version = SSLConnectionInterfaceI::TK_SSL_Version_2_0,
						   SSLCipherManagerInterfaceI::SSLCipherT *cipher_array = NULL,
						   unsigned int num_cipers = 0);
#else
    HttpConnectionInterfaceI *CreateHttpConnection(const char *host, 
						   unsigned int port = 80);
#endif
};


#endif
