//
//    Copyright (C)  1993-1999 Tumbleweed Software Corp.
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA

//
// $Workfile: $
//
// Description:
//    
//    Interface of the IOP/HTTP convertor.
//
//     $Log: IOP_HTTP.h,v $
//     Revision 1.21  1999/06/08 03:06:59  edumas
//     	Some code cleanup.
//
//     Revision 1.20  1999/05/19 15:51:53  edumas
//     	GPL licences.
//
//     Revision 1.19  1999/05/05 21:41:53  edumas
//     	- Add the Root Certificate file reference.
//     	- Cleanup of the SSL configuration.
//     	- Add the SSL specific code between HAS_SSL defines...
//     	- The library can be compiled without SSL. In this case an
//     	exception is thrown, and an error message sent.
//     	- Check of the SSL/non SSL parameters.
//
//     Revision 1.18  1999/05/04 02:49:10  edumas
//     	Proxy with Authentification part1.
//
//     Revision 1.17  1999/04/30 22:21:33  edumas
//     	-> Add two news entries in the config file in order to
//     	take care of the "login/password" proxies.
//     	-> increase the limit of the number of items availables in
//     	the omniORB.cfg config file.
//
//     Revision 1.16  1999/04/29 18:17:00  edumas
//
//     	Proxy - step 1 :
//     	-> add entries in omniORB.cfg (no authentification),
//     	-> forward socket connection to the proxy instead of the
//     		Web server,
//     	-> Non-Authentification proxy implementation.
//     		(Tested with Squid proxy - Unix cache/proxy).
//
//     Revision 1.15  1999/04/17 00:00:12  edumas
//     	-> update of the code with the interfaces modifications
//     	-> create a dummystub library to be used by people who do not
//     		want the HTTP encapsulation (omniNames, etc.)
//     	-> changes in the httpconnection directory in order to
//     		manage multiple libraries.
//
//     Revision 1.14  1999/04/07 17:44:20  edumas
//      Encapsultate the global_iop_http object as a static member of IOP_HTTP.
//     		(Randy's comment).
//
//     Revision 1.13  1999/04/06 00:22:49  edumas
//
//     	Add IOP_HTTPS_PORT config file field.
//
//     Revision 1.12  1999/04/01 03:20:34  edumas
//     	- Thread locking.
//     	- Memory management
//     	- Next set of Randy's comments.
//
//     Revision 1.11  1999/03/26 19:49:52  edumas
//     	Build fix.
//
//     Revision 1.10  1999/03/26 19:13:07  edumas
//     	- add stop_proxy() method,
//     	- Comments.
//
//     Revision 1.9  1999/03/26 01:34:54  edumas
//     	Randy's comments added.
//
//     Revision 1.8  1999/03/25 02:05:42  edumas
//     	First set of Randy's comments modifications:
//     	- version(), get_default*() are made const when returning const char*
//     	- get_port_binded() -> get_port_bound()
//     	-
//
//     Revision 1.7  1999/03/16 02:56:46  edumas
//     	Fix the way we get the binded port of the thread. In the case
//     the port is already used, jump to the next one.
//
//     Revision 1.6  1999/02/19 02:32:26  edumas
//
//     	- Comments update,
//     	- Modify the relaying policies,
//     	- The thread-proxy is now created *only* if we really need to
//     		use it, aka, only if relaying is necessary,
//
//     Revision 1.5  1999/02/16 01:08:05  edumas
//     *** empty log message ***
//
//     Revision 1.4  1999/02/12 03:36:34  edumas
//         IP mapping working integration. Better Corba type handling.
//
//     Revision 1.3  1999/02/11 02:33:33  edumas
//         ip mapping file added.
//
//     Revision 1.2  1999/02/10 01:58:44  edumas
//         IOP_HTTP implementation. This first commit is only a "security" in
//     order to keep track of this version. Should not be used.
//
//     Revision 1.1.1.1  1999/02/09 16:30:17  edumas
//     omniORB 2.6.1 with IOP/HTTP
//
//
// Add new header
//
// $Id: IOP_HTTP.h,v 1.21 1999/06/08 03:06:59 edumas Exp $
//
// $NoKeywords: $
//


/* NOTES:

   THREADS:
   This class is going to create two type of threads:

   ProxyThread: It will act as a protocol relay between the GIOP sockets
   and the HTTP protocol

   SocketThread: one socket has its own socket because HTTPprotocol
   requieres a write() is followed by a read().

   RELAY POLICY:
   the relaying is performed only in the two following cases:

   1- an ip_mapping_file is present and the IP address is in this table,

   2- the default values for relaying have been inserted in the
   omniORB.cfg file.

   In the case [1], only matching IP addresses are relayed,
   In the case [2], *everything* is releayed.  
*/

#ifndef IOP_HTTP_H
#define IOP_HTTP_H

#ifndef IP_MAPPING_FILE
#include <IOP_HTTP/ip_mapping_file.h>
#endif
#ifndef IOP_HTTP_HANDSHAKE_H
#include <IOP_HTTP/IOP_HTTP_handshake.h>
#endif

class HttpConnectionInterfaceI;

class iop_http : public omni_thread {
 public:
  iop_http();
  virtual ~iop_http();

  /* return the module version. */
  const char *version() const;

  /* Check if default values have been redefined... if we have to
   relay data. */
  CORBA::Boolean have_to_relay();
  /* based on the host_to_send, scan the policy data. */
  CORBA::Boolean need_to_relay(const char *host_to_send);

  /* Used by the init_file module, or by any external interface in
     order to set the global variables. This function is thread safe
     using internal omni_mutex locks. */
  int init_file_value(const char *entryname, const char *data);

  /* Bind a socket and create a new thread which is going 
     to listen on this socket. This is the ProxyThread.
  */
  void start_proxy(); /* This is only one proxy by IOP_HTTP object. */
  void stop_proxy();
  
  /* Must be run in separated thread */
  int  thread_iop_http_proxy    (void *incoming_fd);
  int  thread_listen_bind_socket(void *incoming_fd);

  /* Access methods */
  const char   *get_default_hostname()  const   { return pd_default_hostname; }
  unsigned int  get_default_port()              { return pd_default_port; }
  const char   *get_default_path()      const   { return pd_default_path; }
  const char   *get_default_mime_type() const   { return pd_default_mime_type; }
  unsigned int  get_port_bound()                { return pd_port_to_bind; }
  


 public:
  // Do not access it directly. Use IopHttpManager().
  static iop_http *global_iop_http;
  
 private:
  ip_mapping_file ipf;

  void read_orb_write_http(int listenfd, HttpConnectionInterfaceI *http,
			   struct iop_http_handshake &handshake,
			   const char *mime_type,
			   const char *path);

  static const CORBA::Boolean is_valid_port(unsigned int p);

  /* Methods launched by threads */
  static void iop_http_proxy_s    (void *fd);
  static void listen_bind_socket_s(void *fd);

  char         *pd_default_hostname;
  unsigned int  pd_default_port;
  unsigned int  pd_default_port_https;
  char         *pd_default_path;
  char         *pd_default_mime_type;

  /* SSL Stuff */
  unsigned char pd_SSL_requiered;
  char         *pd_SSL_root_certificates;

  /* Proxy stuff */
  char         *pd_remote_proxy_hostname;
  unsigned int  pd_remote_proxy_port;
  char         *pd_remote_proxy_login;
  char         *pd_remote_proxy_password;
  char         *pd_remote_proxy_auth;
 
  unsigned int  pd_port_to_bind;
};

extern iop_http &IopHttpManager();

#endif /* IOP_HTTP_H */
