//
//    Copyright (C)  1993-1999 Tumbleweed Software Corp.
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
// $Workfile: $
//
// Description:
//    
//    Interface of the send Post HTTP requests.
//
//     $Log: IOP_HTTP_external.h,v $
//     Revision 1.7  1999/05/19 15:52:40  edumas
//     	GPL licence.
//
//     Revision 1.6  1999/05/05 21:40:21  edumas
//     	Add the Root Certificate file reference.
//     	Cleanup of the SSL configuration.
//
//     Revision 1.5  1999/04/30 22:21:33  edumas
//     	-> Add two news entries in the config file in order to
//     	take care of the "login/password" proxies.
//     	-> increase the limit of the number of items availables in
//     	the omniORB.cfg config file.
//
//     Revision 1.4  1999/04/29 18:15:25  edumas
//     	Add two new entries in the omniORB.cfg file in order to manage
//     proxy (currently, without authentification).
//
//     Revision 1.3  1999/04/06 00:23:06  edumas
//     	Add IOP_HTTPS_PORT config field.
//
//     Revision 1.2  1999/04/01 03:19:12  edumas
//     	Header cleanup.
//
//     Revision 1.1  1999/02/10 01:54:22  edumas
//         External interfaces for IOP_HTTP.
//
//
//
// $Id: IOP_HTTP_external.h,v 1.7 1999/05/19 15:52:40 edumas Exp $
//
// Add new header
//
// $NoKeywords: $
//

#ifndef IOP_HTTP_EXTERNAL_H
#define IOP_HTTP_EXTERNAL_H

/*
  ORB Config file 
*/

/* Variables used in the ORB init file */
#define IOP_HTTP_IP_MAPPING_FILENAME "IOP_HTTP_IP_MAPPING" /* Default IP mapping file to use */
#define IOP_HTTP_BIND_PORT           "IOP_HTTP_BIND_PORT"  /* Port number to bind            */

/* These variables are used only if the IP Mapping file is not defined */
#define IOP_HTTP_PORT                "IOP_HTTP_PORT"       /* Default Http port to access  */
#define IOP_HTTPS_PORT               "IOP_HTTPS_PORT"     /* Default Https port to access */
#define IOP_HTTP_HOST                "IOP_HTTP_HOST"       /* Default host to access   */
#define IOP_HTTP_PATH                "IOP_HTTP_PATH"       /* Default path to access   */
#define IOP_HTTP_MIME_TYPE           "IOP_HTTP_MIME_TYPE"  /* Default MIME type to use */
#define IOP_HTTP_SSL_POLICY          "IOP_HTTP_SSL_POLICY" /* Admin SSL policy         */

/* SSL RootCertificates */
#define IOP_HTTP_SSL_ROOTCERT_FILE   "IOP_HTTP_SSL_ROOTCERT_FILE" /* Filename for the Root Certificates */

/* Proxy definitions */
#define IOP_HTTP_REMOTE_PROXY_HOSTNAME      "IOP_HTTP_REMOTE_PROXY_HOSTNAME" /* Proxy hostname */
#define IOP_HTTP_REMOTE_PROXY_PORT          "IOP_HTTP_REMOTE_PROXY_PORT"     /* Proxy hostname */
#define IOP_HTTP_REMOTE_PROXY_LOGIN         "IOP_HTTP_REMOTE_PROXY_LOGIN"    /* Proxy login name */
#define IOP_HTTP_REMOTE_PROXY_PASSWORD      "IOP_HTTP_REMOTE_PROXY_PASSWORD" /* Proxy password */

/* States of SSL connection */
enum SSL_State {
  SSL_UNKNOWN      = 0,

  SSL_REQUIRED     = 1, 
  SSL_NOT_REQUIRED = 2, 

  SSL_LAST_VALUE   = 3
};

#endif
