// -*- Mode: C++; -*-
//                            Package   : omniEvents
// naming.cc                  Created   : 1/10/99
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//
//    naming Service Utility functions.
//

/*
  $Log: naming.cc,v $
  Revision 1.3  2000/09/26 08:44:58  naderp
  Added stdlib.h include for exit function.

  Revision 1.2  2000/09/04 03:45:52  naderp
  Changed headers.

  Revision 1.1  1999/11/01 17:00:16  naderp
  Initial revision

*/

#include <naming.h>
#include <stdio.h>
#include <stdlib.h>

CosNaming::NamingContext_ptr
getRootNamingContext(CORBA::ORB_ptr orb)
{
  CosNaming::NamingContext_ptr rootContext;
  try {

     // Get initial reference.
     CORBA::Object_var initServ;
     initServ = orb->resolve_initial_references("NameService");

     // Narrow the object returned by resolve_initial_references()
     // to a CosNaming::NamingContext object:
     rootContext = CosNaming::NamingContext::_narrow(initServ);
     if (CORBA::is_nil(rootContext))
     {
        cerr << "Failed to narrow naming context." << endl;
        exit(1);
     }
  }
  catch(CORBA::ORB::InvalidName& ex) {
     cerr << "Service required is invalid [does not exist]." << endl;
     exit(1);
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE."
          << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception" << endl;
     throw;
  }
  catch (...) {
     cerr << "Caught a system exception while resolving the naming service."
          << endl;
     exit(1);
  }
  return rootContext;
}

ostream& operator<<(ostream& os, const CosNaming::Name &n)
{
   long length = n.length();
   for (long l=0; l<length; l++)
   {
      os << "\"" << (const char *) n[l].id << "\"/\"" << (const char *) n[l].kind << "\" ";
   }
   return os;
}

void
bindName2Object(CosNaming::NamingContext_ptr c,
	        const CosNaming::Name & n,
                CORBA::Object_ptr obj)
{

  try {
    c->bind(n, obj);
  }
  catch(CosNaming::NamingContext::AlreadyBound& ex)
  {
    // overwrite previously bound object
    c->rebind(n, obj);
  }
  catch (CORBA::COMM_FAILURE& ex)
  {
     cerr << "Caught system exception COMM_FAILURE, unable to contact the "
          << "naming service." << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex)
  {
     cerr << "Caught Fatal Exception binding " << n << endl;
     exit(1);
  }
  catch (...) {
     cerr << "Caught unexpected Exception binding " << n << endl;
     exit(1);
  }
}
ostream& operator<<(ostream& os, const omniORB::objectKey &k)
{
  omniORB::seqOctets* ostr = omniORB::keyToOctetSequence(k);
  //
  // Recoord current flags
  os << hex;
  for (unsigned int i = 0; i < ostr->length(); i++) {
#if !defined(__SUNPRO_CC) || __SUNPRO_CC < 0x500
    os << setfill('0') << setw(2) << (int)(*ostr)[i];
#else
    // Eventually, use the following for all standard C++ compilers
    os << std::setfill('0') << std::setw(2) << (int)(*ostr)[i];
#endif
  }
  os << dec;
  delete ostr;
  return os;
}


void
str2key(omniORB::objectKey& k, char *str)
{
  int l = strlen(str) / 2;
  omniORB::seqOctets os(l);
  os.length(l);
  char* p = str;
  for (int i = 0; i < l; i++) {
    int n;
    sscanf(p,"%02x",&n);
    os[i] = n;
    p += 2;
  }
  k = omniORB::octetSequenceToKey(os);
  delete [] str;
}


