#############################################################################
#   Site-Specific Configurable Paramters                                    #
#############################################################################

# Undefine STL_HAS_DEFAULT_ARGS if the STL implementation does not support
# default ordering and allocator arguments for the set container and default
# allocator arguments for the list container. Rarely needed as the default
# behaviour (ie default arguments are supported) is accepted by most well
# behaved STLs.
#
STL_HAS_DEFAULT_ARGS = 1

# Define STL_NO_ALLOCATOR_ARGS of the STL implementation does not accept
# arguments in the allocator template (ie, allocator). The default, supported 
# by most STL implementations is for the allocator template to accept
# arguments (ie allocator<T>). This option is only effective if the
# parameter STL_HAS_DEFAULT_ARGS is not defined. HPUX 11.00 requires this
# option to be set when used with the Rogue STL implementation.
#
# STL_NO_ALLOCATOR_ARGS = 1

# Define STL_INCLUDE_PATH if the STL headers are located in a directory
# not searched by the complier by default.
#
# STL_INCLUDE_PATH = 

# Define STL_LIBRARY_PATH if the STL libraries are located in a directory
# not searched by the linker by default.
#
# STL_LIBRARY_PATH =  

# Define STL_LIBRARY_NAME to be the name of the library implementing the STL
# if it is not known by the linker. For UNIX platforms specify the name you
# would normally pass to your linker with the -l option (eg set it to X if the
# library is called libX.a). For Win32 platforms, use the complete library
# file name (eg set it to std.lib if the file is called std.lib).
#
# STL_LIBRARY_NAME =  

# Define TEMPLATE_REPDIR to be the name of the directory where the compiler
# generates instanciated template object files. For example, the Sun C++ 4.2
# compiler creates a directory called Templates.DB by default.
#
# TEMPLATE_REPOSITORY_DIR =

# Define OMNIEVENTS_LOG_DEFAULT_LOCATION to specify the default location where
# the omniEvents server executable places its persistency log file. The default
# location is C:\TEMP for Win32 and /var/omniEvents for UNIX systems by default.
# The location can be overriden at runtime using the OMNIEVENTS_LOGDIR
# environment variable.
#
# OMNIEVENTS_LOG_DEFAULT_LOCATION =

# Define OMNIEVENTS_LOG_CHECKPOINT_PERIOD to specify the number of seconds
# the omniEvents server executable should wait before persistency log check-
# points. The default value is 900 (ie 15 minutes). You should adjust this
# value depending on how often operations involving state changes are performed.
# Operations of this type include creating event channels and connecting or
# disconnecting clients. Lowering the period reduces the maximum size of the
# logfile.
#
# OMNIEVENTS_LOG_CHECKPOINT_PERIOD = 900
