#############################################################################
#   dir.mk for omniEvents shared library                                    #
#############################################################################

#
# Build a shared library in this directory
# **** DO NOT forget to update the $(VERSION) number.
#

# The Version number is constructed as follows:
#    <major version no.>.<minor version no.>.<micro version no.>
#
# The <minor version no.> changes when:
#   1. Public interfaces have been extended but remains backward compatible
#      with earlier minor version.
#   2. Internal interfaces have been changed.
#
# The <micro version no.> changes when the implementation has been changed
# but both the public and internal interfaces remain the same. This usually
# corresponds to a pure bug fix release.
#
# 

VERSION = 2.1.0

major_version = $(word 1,$(subst ., ,$(VERSION)))
minor_version = $(word 2,$(subst ., ,$(VERSION)))
micro_version = $(word 3,$(subst ., ,$(VERSION)))

#
# For each source tree we want to search the parent directory to get source
# files so we put these on VPATH.  However we can't put the parent build
# directory ('..') on VPATH otherwise the .o files in there are used.  So we
# need to do that as a special case with the vpath directive:
#

override VPATH := $(patsubst %,%/..,$(VPATH))

ifndef BuildWin32DebugLibraries

vpath %.cc .. ../../fe ../../util ../../idl ../../../../../stub
vpath %.idl ../../idl

else

vpath %.cc ../.. ../../../fe ../../../util ../../../idl
vpath %.idl ../../../idl

endif

#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

include ../../config/config.mk

EXPORT_TREE     = ../..

INTERFACES	= Naming \
                  EventChannelAdmin \
                  CosLifeCycle \
                  CosEventComm \
                  CosEventChannelAdmin

CORBAOBJS	= $(INTERFACES:%=%SK.o)

CXXSRCS         = omniEvents.cc \
                  args.cc \
                  naming.cc \
                  y.tab.cc \
                  lex.yy.cc \
                  oep_types.cc \
                  oep_global.cc \
                  CosEvent_i.cc \
                  omniEventsLog.cc \
                  EventChannelFactory_i.cc

LIBOBJS         = $(CORBAOBJS) \
                  args.o \
                  naming.o \
                  y.tab.o \
                  lex.yy.o \
                  oep_types.o \
                  oep_global.o \
                  CosEvent_i.o \
                  omniEventsLog.o \
                  EventChannelFactory_i.o

OMNIEVENTSOBJS  = omniEvents.o

omniEvents      = $(patsubst %,$(BinPattern),omniEvents)

EXECS		= $(omniEvents)

ifdef STL_INCLUDE_PATH
DIR_CPPFLAGS    += -I$(STL_INCLUDE_PATH)
endif

ifdef  STL_LIBRARY_NAME
STL_LIB += $(patsubst %, $(LibSearchPattern), $(STL_LIBRARY_NAME))
endif

ifdef STL_HAS_DEFAULT_ARGS
DIR_CPPFLAGS    += -DSTL_HAS_DEFAULT_ARGS
else
ifdef STL_NO_ALLOCATOR_ARGS
DIR_CPPFLAGS    += -DSTL_NO_ALLOCATOR_ARGS
endif
endif

ifdef OMNIEVENTS_LOG_CHECKPOINT_PERIOD
DIR_CPPFLAGS    += -DOMNIEVENTS_LOG_CHECKPOINT_PERIOD=$(OMNIEVENTS_LOG_CHECKPOINT_PERIOD)
endif

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

ifdef OMNIEVENTS_LOG_DEFAULT_LOCATION
DEFAULT_LOGDIR = $(OMNIEVENTS_LOG_DEFAULT_LOCATION)
else
DEFAULT_LOGDIR = C:\\TEMP
endif

ifdef STL_LIBRARY_PATH
IMPORT_LIBRARY_FLAGS += -libpath:$(STL_LIBRARY_PATH)
endif

OMNIEVENTSOBJS	+= getopt.o
DIR_CPPFLAGS    += -I../../include $(CORBA_CPPFLAGS)
DIR_CPPFLAGS    += -DUSE_dyn_stub_in_nt_dll
DIR_CPPFLAGS    += -DDEFAULT_LOGDIR='"$(DEFAULT_LOGDIR)"'

else

#############################################################################
#   Make variables for Unix platforms                                       #
#############################################################################

ifdef OMNIEVENTS_LOG_DEFAULT_LOCATION
DEFAULT_LOGDIR = $(OMNIEVENTS_LOG_DEFAULT_LOCATION)
else
DEFAULT_LOGDIR = /var/omniEvents
endif

ifdef STL_LIBRARY_PATH
IMPORT_LIBRARY_DIRS += $(STL_LIBRARY_PATH)
endif

DIR_CPPFLAGS    += -I../../include -I../../fe
DIR_CPPFLAGS	+= $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES
DIR_CPPFLAGS    += -DDEFAULT_LOGDIR='"$(DEFAULT_LOGDIR)"'
IMPORT_LIBRARY_FLAGS += $(patsubst %,$(LibPathPattern),$(EXPORT_TREE)/$(LIBDIR))

endif

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

ifndef BuildWin32DebugLibraries

implib = $(patsubst %,$(DLLPattern),omniEvents$(major_version)$(minor_version)$(micro_version))
staticlib = ../$(patsubst %,$(LibPattern),omniEvents)
CXXOPTIONS  = $(MSVC_DLL_CXXNODEBUGFLAGS)
CXXLINKOPTIONS = $(MSVC_DLL_CXXLINKNODEBUGOPTIONS)

# Temporarily Commented until static debug library is implemented
# SUBDIRS = debug
SUBDIRS =

else

# Building the debug version of the library in the debug subdirectory.
# Notice that this dir.mk is recursively used in the debug directory to build
# this library. The BuildWin32DebugLibraries make variable is set to 1 in
# the dir.mk generated in the debug directory.
#
implib = $(patsubst %,$(DLLDebugPattern),omniEvents$(major_version)$(minor_version)$(micro_version))
staticlib = ../../debug/$(patsubst %,$(LibDebugPattern),omniEvents)
CXXDEBUGFLAGS =
CXXOPTIONS = $(MSVC_DLL_CXXDEBUGFLAGS)
CXXLINKOPTIONS = $(MSVC_DLL_CXXLINKDEBUGOPTIONS)
DIR_CPPFLAGS += -I../../../include

SUBDIRS =

endif

lib = $(patsubst %.lib,%.dll,$(implib))
libname = $(patsubst %.dll,%,$(lib))

endif

#############################################################################
#   Make rules for  Solaris 2.x                                             #
#############################################################################

ifdef SunOS

libname = libomniEvents.so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

ifeq ($(notdir $(CXX)),CC)

DIR_CPPFLAGS += -Kpic

all:: $(lib) $(EXECS)

$(lib): $(LIBOBJS)
	(set -x; \
        $(RM) $@; \
        CC -G -o $@ -h $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-R %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^) -lpthread -lposix4; \
       )

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(EXECS)

endif

ifeq ($(notdir $(CXX)),g++)

DIR_CPPFLAGS += -fPIC

all:: $(lib) $(EXECS)

$(lib): $(LIBOBJS)
	(set -x; \
        $(RM) $@; \
        $(CXX) $(CXXOPTIONS) -shared -Wl,-h,$(soname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) -lpthread -posix4; \
       )

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(EXECS)

endif

endif

#############################################################################
#   Make rules for  Digital Unix                                            #
#############################################################################

ifdef OSF1
ifeq ($(notdir $(CXX)),cxx)

libname = libomniEvents.so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

all:: $(lib) $(EXECS)

$(lib): $(LIBOBJS)
	(rpath="$(RPATH)"; \
         for arg in $(OMNITHREAD_LIB) /usr/lib/cmplrs/cxx; do \
         if expr "$$arg" : "-L" >/dev/null; then \
               rpath="$$rpath$${rpath+:}`expr $$arg : '-L\(.*\)'"; \
         fi; \
         done; \set -x; \
         $(RM) $@; \
         ld -shared -soname $(soname) -set_version $(soname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) $(OMNITHREAD_LIB) -lcxxstd -lcxx -lexc -lots -lc -rpath $$rpath; \
        )

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(EXECS)

endif
endif

#############################################################################
#   Make rules for  Linux egcs                                              #
#############################################################################

ifdef Linux
ifdef EgcsMajorVersion

DIR_CPPFLAGS += -fPIC

libname = libomniEvents.so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

all:: $(lib) $(EXECS)

$(lib): $(LIBOBJS)
	(set -x; \
        $(RM) $@; \
        $(CXX) $(CXXOPTIONS) -shared -Wl,-soname,$(soname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^); \
       )

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(EXECS)

endif
endif

#############################################################################
#   Make rules for IBM AIX                                                  #
#############################################################################

ifdef AIX

libname = libomniEvents$(minor_version).a
soname  = libomniEvents.so.$(minor_version).$(micro_version)
lib = $(libname).$(micro_version)

all:: $(lib) $(EXECS)

ifeq ($(notdir $(CXX)),xlC_r)

$(lib): $(LIBOBJS)
	(set -x; \
        $(RM) $@; \
        $(MAKECPPSHAREDLIB) \
             -o $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) \
         -p 40; \
         ar cq $(lib) $(soname) ; \
         $(RM) $(soname) ; \
       )

endif

ifeq ($(notdir $(CXX)),g++)

$(lib): $(LIBOBJS)
	(set -x; \
         $(RM) $@; \
         $(CXXLINK) -shared -mthreads \
              -o $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^) \
         -lpthreads; \
         ar cq $(lib) $(soname); \
         $(RM) $(soname); \
	)

endif

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(libname); \
          ln -s $(lib) $(libname); \
         )

export:: $(EXECS)

endif

#############################################################################
#   Make rules for to Win32 platforms                                       #
#############################################################################

ifdef Win32Platform

ifndef BuildWin32DebugLibraries
# Prepare a debug directory for building the debug version of the library.
# Essentially, we create a debug directory in the current directory, create
# a dir.mk and optionally a GNUmakefile in that directory and then calling
# omake (GNU make) in that directory.
# The confusing bit is that this dir.mk is recursively used in the debug 
# directory to build this library. The BuildWin32DebugLibraries make variable,
# which is set to 1 in the dir.mk generated in the debug directory,
# is used to identify this case.
#
#all:: mkdebugdir
#
#mkdebugdir:
#	@(if [ ! -f debug/dir.mk ]; then \
#            file=dir.mk; dirs='. $(VPATH:/..=)'; $(FindFileInDirs); \
#            case "$$fullfile" in /*) ;; *) fullfile=../$$fullfile;; esac; \
#            dir=debug; $(CreateDir); \
#            echo 'BuildWin32DebugLibraries = 1' > debug/dir.mk; \
#            echo 'override EXPORT_TREE := ../../..' >> debug/dir.mk; \
#            echo 'override VPATH := $$(VPATH:/debug=)' >> debug/dir.mk; \
#            echo include $$fullfile >> debug/dir.mk; \
#            if [ -f GNUmakefile ]; then \
#               echo 'TOP=../../../../../..' > debug/GNUmakefile; \
#               echo 'CURRENT=src/contrib/omniEvents/utils/sharedlib/debug' >> debug/GNUmakefile; \
#               echo 'include $$(TOP)/config/config.mk' >> debug/GNUmakefile; \
#            fi \
#          fi \
#         )
#
#export:: mkdebugdir
#
endif

all:: $(lib) $(EXECS)

all::
	@$(MakeSubdirs)

$(lib): $(LIBOBJS) msvcdllstub.o omniEvents.def
	(libs="$(NT_EXTRA_LIBS) $(OMNITHREAD_LIB) $(OMNIORB_LIB)"; \
	 $(RM) $@; \
        $(CXXLINK) -out:$@ -DLL $(CXXLINKOPTIONS) -def:omniEvents.def -IMPLIB:$(implib) $(IMPORT_LIBRARY_FLAGS) $(LIBOBJS) $$libs; \
        )

# Alas a bug in MSVC++ prevents the data member
# EventChannelAdmin::EventChannelFactory::_PD_repoId from being included in 
# the DLL, so we just link in the stubs required. PWN

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="EventChannelAdminSK.o CosLifeCycleSK.o $(implib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

# omniEvents.def
#  - This file contains all the functions and static class variables
#    exported by the DLL. The symbols are extracted from the output of
#    dumpbin.
#
#    The function symbols are extracted using the following template:
#    ... ........ SECT..  notype ()     External      | ?..................
#
#    The static class variable symbols are extracted using the following
#    template:
#    ... ........ SECT..  notype        External      | ?[^?]..............
#
#    Default destructors generated by the compiler are excluded.
#
#    It looks like class variable and function symbols start with two ??
#    and class static variable and static function symbols start with one ?.
#                                                             - SLL
#
omniEvents.def: $(staticlib)
	(set -x; \
	echo "LIBRARY $(libname)" > omniEvents.def; \
	echo "DESCRIPTION omniEvents Shared Library Implemenation" >> omniEvents.def; \
	echo "VERSION $(minor_version).$(micro_version)" >> omniEvents.def; \
	echo "EXPORTS" >> omniEvents.def; \
	DUMPBIN.EXE /SYMBOLS $(staticlib) | \
	egrep '^[^ ]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +\(\) +External +\| +\?[^ ]*|^[^]+ +[^ ]+ +SECT[^ ]+ +[^ ]+ +External +\| +\?[^?][^ ]*'|\
        egrep -v 'deleting destructor[^(]+\(unsigned int\)' | \
        cut -d'|' -f2 | \
        cut -d' ' -f2 | $(SORT) -u >> omniEvents.def; )


# A feature or a bug in MSVC++ causes it to generate a bunch of references
# to a list of functions even though none of the these functions are actually
# used in the DLL. This file contain stub version of these functions. The
# real function definitions are in the dynamic DLL. Notice that none
# of the stubs are exported by this DLL so they would not clash with
# the ones exported by the dynamic DLL.
msvcdllstub.o: sharedlib/msvcdllstub.cc
	$(CXX) -c $(CXXFLAGS) -Fo$@ $<

clean::
	$(RM) $(EXECS) *.lib *.def *.dll *.exp *.d

clean::
	@$(MakeSubdirs)

# NT treats DLLs more like executables -- the .dll file needs to go in the
# bin/x86... directory so that it's on your PATH:
export:: $(lib)
	@$(ExportExecutable)

export:: $(implib)
	@$(ExportLibrary)

export:: $(EXECS)

export::
	@$(MakeSubdirs)

endif

#############################################################################
#   Make rules for HPUX                                                     #
#############################################################################

ifdef HPUX
ifeq ($(notdir $(CXX)),aCC)

DIR_CPPFLAGS += +Z

libname = libomniEvents.sl
soname  = $(libname).$(minor_version)
lib     = $(soname).$(micro_version)

all:: $(lib) $(EXECS)


$(lib): $(LIBOBJS)
	(set -x; \
        $(RM) $@; \
         aCC -b -Wl,+h$(soname) -o $@  $(IMPORT_LIBRARY_FLAGS) \
         $(patsubst %,-L %,$(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^) $(HPTHREADLIBS) ; \
       )

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(lib) $(EXECS)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(EXECS)

endif
endif

#############################################################################
#   Make rules for to Reliant Unix                                          #
#############################################################################

ifdef SINIX
ifeq ($(notdir $(CXX)),CC)

DIR_CPPFLAGS += -Kpic

libname = libomniEvents.so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

all:: $(lib) $(EXECS)

$(lib): $(LIBOBJS)
	(set -x; \
        $(RM) $@; \
        CC -G -z text -Kthread -KPIC -o $@ -h $(soname) $(IMPORT_LIBRARY_FLAGS) \
         $($(IMPORT_LIBRARY_DIRS)) \
         $(filter-out $(LibSuffixPattern),$^); \
       )

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(EXECS)

endif
endif

#############################################################################
#   Make rules for  SGI Irix 6.2                                            #
#############################################################################

ifdef IRIX
ifeq ($(notdir $(CXX)),CC)

DIR_CPPFLAGS += -KPIC

libname = libomniEvents.so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

all:: $(lib) $(EXECS)

$(lib): $(LIBOBJS)
	(set -x; \
        $(RM) $@; \
        $(LINK.cc) -KPIC -shared -Wl,-h,$(libname) -Wl,-set_version,$(soname) \
         -o $@ $(IMPORT_LIBRARY_FLAGS) $^; \
       )

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(EXECS)

endif
endif

#############################################################################
#   Make rules for FreeBSD 3.x egcs                                         #
#############################################################################

ifdef FreeBSD
ifdef EgcsMajorVersion

DIR_CPPFLAGS += -fPIC

libname = libomniEvents.so
soname  = $(libname).$(minor_version)
lib = $(soname).$(micro_version)

all:: $(lib) $(EXECS)

$(lib): $(LIBOBJS)
	(set -x; \
        $(RM) $@; \
        $(CXX) $(CXXOPTIONS) -shared -Wl,-soname,$(soname) -o $@ $(IMPORT_LIBRARY_FLAGS) \
         $(filter-out $(LibSuffixPattern),$^); \
       )

$(omniEvents): $(OMNIEVENTSOBJS)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(lib)
	@$(ExportLibrary)
	@(set -x; \
          cd $(EXPORT_TREE)/$(LIBDIR); \
          $(RM) $(soname); \
          ln -s $(lib) $(soname); \
          $(RM) $(libname); \
          ln -s $(soname) $(libname); \
         )

export:: $(EXECS)

endif
endif
