#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

include ../config/config.mk

vpath %.idl ../idl

EXPORT_TREE	= ..

INTERFACES	= Naming \
		  CosLifeCycle \
		  CosEventComm \
		  CosEventChannelAdmin \
		  EventChannelAdmin

CORBAOBJS	 = $(INTERFACES:%=../idl/%SK.o)

CXXSRCS		= omniEvents.cc \
 		  CosEvent_i.cc \
		  omniEventsLog.cc \
		  EventChannelFactory_i.cc

LIBOBJS		= ../util/args.o \
		  ../util/naming.o \
		  ../fe/y.tab.o \
		  ../fe/lex.yy.o \
		  ../fe/oep_types.o \
		  ../fe/oep_global.o \
		  CosEvent_i.o \
		  omniEventsLog.o \
		  EventChannelFactory_i.o

OMNIEVENTSOBJS	= omniEvents.o

ifdef STL_INCLUDE_PATH
DIR_CPPFLAGS	+= -I$(STL_INCLUDE_PATH)
endif

ifdef STL_HAS_DEFAULT_ARGS
DIR_CPPFLAGS    += -DSTL_HAS_DEFAULT_ARGS
else
ifdef STL_NO_ALLOCATOR_ARGS
DIR_CPPFLAGS    += -DSTL_NO_ALLOCATOR_ARGS
endif
endif

ifdef TEMPLATE_REPOSITORY_DIR
REPOBJS		+= ../fe/$(TEMPLATE_REPOSITORY_DIR)/*.o
REPOBJS		+= ./$(TEMPLATE_REPOSITORY_DIR)/*.o
endif

ifdef OMNIEVENTS_LOG_CHECKPOINT_PERIOD
DIR_CPPFLAGS	+= -DOMNIEVENTS_LOG_CHECKPOINT_PERIOD=$(OMNIEVENTS_LOG_CHECKPOINT_PERIOD)
endif

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

ifdef OMNIEVENTS_LOG_DEFAULT_LOCATION
DEFAULT_LOGDIR = $(OMNIEVENTS_LOG_DEFAULT_LOCATION)
else
DEFAULT_LOGDIR = C:\\TEMP
endif

ifdef STL_LIBRARY_PATH
IMPORT_LIBRARY_FLAGS += -libpath:$(STL_LIBRARY_PATH)
endif

ifdef STL_LIBRARY_NAME
STL_LIB = $(STL_LIBRARY_NAME)
endif

SUBDIRS		= sharedlib
OMNIEVENTSOBJS	+= ../util/getopt.o
DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS)
DIR_CPPFLAGS	+= -DDEFAULT_LOGDIR='"$(DEFAULT_LOGDIR)"'
DIR_CPPFLAGS	+= -DSTL_HAS_DEFAULT_ARGS

else

#############################################################################
#   Make variables Common to all Unix platforms                             #
#############################################################################

ifdef OMNIEVENTS_LOG_DEFAULT_LOCATION
DEFAULT_LOGDIR = $(OMNIEVENTS_LOG_DEFAULT_LOCATION)
else
DEFAULT_LOGDIR = /var/omniEvents
endif

ifdef STL_LIBRARY_PATH
IMPORT_LIBRARY_DIRS += $(STL_LIBRARY_PATH)
endif

ifdef STL_LIBRARY_NAME
STL_LIB = $(patsubst %, $(LibSearchPattern), $(STL_LIBRARY_NAME))
endif

SUBDIRS		= sharedlib
DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES
DIR_CPPFLAGS	+= -DDEFAULT_LOGDIR='"$(DEFAULT_LOGDIR)"'

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

omniEvents	= $(patsubst %,$(BinPattern),omniEvents)
lib		= $(patsubst %,$(LibPattern),omniEvents)
EXECS		= $(omniEvents)

all:: $(lib) $(EXECS)

all::
	@$(MakeSubdirs)

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(omniEvents)
	@$(ExportExecutable)

export:: $(lib)
	@$(ExportLibrary)

export::
	@$(MakeSubdirs)

$(lib): $(LIBOBJS) $(REPOBJS) $(CORBAOBJS)
	@$(StaticLinkLibrary)

$(omniEvents): $(OMNIEVENTSOBJS) $(lib)
	@(libs="$(lib) $(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))
