// -*- Mode: C++; -*-
//                            Package   : omniEvents
// omniEvents.h	              Created   : 1/10/99
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//
// Main include file for the omniEvents process. Includes the rest of the
// files defining the persistency front-end parser.

/*
  $Log: omniEvents.h,v $
  Revision 1.1  2000/09/04 03:44:19  naderp
  Changed to fix DEC platform build problems.

  Revision 1.0  1999/11/01 16:48:18  naderp
  Initial revision

*/

#ifndef _OMNIEVENTS_H_
#define _OMNIEVENTS_H_

#ifdef __WIN32__
#include <iostream>
using namespace std;
#include <fstream>
#include <iomanip>
#else
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#endif

#include	<stdio.h>		// C Standard Lib
#include	<stdlib.h>		// POSIX standard defns
#include	<string.h>		// POSIX string funcs
#if defined(__aix__) || defined(__SINIX__) || defined(__uw7__)
#include        <strings.h>
#endif
#include	<ctype.h>		// External functions

#define YYDEBUG 1

#include	<sys/types.h>		// POSIX standard types
#include	<oep_types.h>		// OEP grammar data types
#include	<oep_global.h>		// OEP Global data

extern OEP_GlobalData *oep_global;

#endif           // _OMNIEVENTS_H_
