// -*- Mode: C++; -*-
//                            Package   : omniEvents
// oep_types.h                Created   : 1/10/99
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//

/*
  $Log: oep_types.h,v $
  Revision 1.8  2000/10/03 08:37:14  naderp
  *** empty log message ***

  Revision 1.7  2000/09/26 08:42:41  naderp
  Configurable STL default parameters.

  Revision 1.6  2000/09/05 01:07:40  naderp
  Added MaxQueueLength QOS.

  Revision 1.5  2000/09/04 03:42:19  naderp
  Naming.hh no longer required. Replaced with omniORB.h.

  Revision 1.4  2000/08/30 04:17:48  naderp
  Port to omniORB 3.0.1.

  Revision 1.3  2000/03/06 13:06:53  naderp
  Removed EventChannelFactory dependency with Naming Service.
  Moved port from COMMON to channelFactory.

  Revision 1.2  2000/03/02 03:41:59  naderp
  Changed Proxy containment from channel to admin objects.
  Added Support for multiple admin objects per channel.

  Revision 1.1  1999/11/02 15:37:39  naderp
  *** empty log message ***

 * Revision 1.0  99/11/01  16:48:16  16:48:16  naderp (Paul Nader)
 * Initial revision
 * 
*/

#ifndef __OEP_TYPES_H_
#define __OEP_TYPES_H_

#include <list>
#ifdef _MSC_VER
using namespace std;
#endif

#include <omniORB3/CORBA.h>
#include <omniORB3/omniORB.h>

class OEP_prxy;
class OEP_caps;
class OEP_saps;
class OEP_ecps;


#ifdef HAS_DEFAULT_STL_ARGS
typedef list<OEP_prxy *> OepPrxyList;
typedef list<OEP_caps *> OepCapsList;
typedef list<OEP_saps *> OepSapsList;
typedef list<OEP_ecps *> OepEcpsList;
#else
#ifdef STL_NO_ALLOCATOR_ARGS
#define STL_ALLOCATOR(T) allocator
#else
#define STL_ALLOCATOR(T) allocator<T>
#endif
typedef list<OEP_prxy *, STL_ALLOCATOR(OEP_prxy *) > OepPrxyList;
typedef list<OEP_caps *, STL_ALLOCATOR(OEP_caps *) > OepCapsList;
typedef list<OEP_saps *, STL_ALLOCATOR(OEP_saps *) > OepSapsList;
typedef list<OEP_ecps *, STL_ALLOCATOR(OEP_ecps *) > OepEcpsList;
#endif

//------------------------------------------------------------------------
// Proxy Persistent Data Representation
//------------------------------------------------------------------------

class OEP_prxy
{
public:
  OEP_prxy();
  virtual ~OEP_prxy();

public:
  void setIor(char *ior);
  const char *getIor(void) const;
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;

private:
  omniORB::objectKey *key;
  char *ior;
};

//------------------------------------------------------------------------
// Consumer Admin Persistent Data Representation
//------------------------------------------------------------------------

class OEP_caps
{
public:
  OEP_caps();
  virtual ~OEP_caps();

public:
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;
  void addProxyPushSupplier(OEP_prxy *);
  const OepPrxyList &getProxyPushSuppliers(void) const;
  void addProxyPullSupplier(OEP_prxy *);
  const OepPrxyList &getProxyPullSuppliers(void) const;

private:
  OepPrxyList ppss;
  OepPrxyList ppls;
  omniORB::objectKey *key;
};

//------------------------------------------------------------------------
// Supplier Admin Persistent Data Representation
//------------------------------------------------------------------------

class OEP_saps
{
public:
  OEP_saps();
  virtual ~OEP_saps();

public:
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;
  void addProxyPushConsumer(OEP_prxy *);
  const OepPrxyList &getProxyPushConsumers(void) const;
  void addProxyPullConsumer(OEP_prxy *);
  const OepPrxyList &getProxyPullConsumers(void) const;

private:
  OepPrxyList ppsc;
  OepPrxyList pplc;
  omniORB::objectKey *key;
};

//------------------------------------------------------------------------
// Event Channel Persistent Data Representation
//------------------------------------------------------------------------
class OEP_ecps
{
public:
  OEP_ecps();
  virtual ~OEP_ecps();

public:
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;
  void addConsumerAdmin(OEP_caps *cadm);
  const OepCapsList &getConsumerAdmins(void) const;
  void addSupplierAdmin(OEP_saps *cadm);
  const OepSapsList &getSupplierAdmins(void) const;
  void setPullRetryPeriod(long);
  long getPullRetryPeriod(void) const;
  void setMaxQueueLength(long);
  long getMaxQueueLength(void) const;
  void setMaxEventsPerConsumer(long);
  long getMaxEventsPerConsumer(void) const;

private:
  omniORB::objectKey *key;
  OepCapsList cadm;
  OepSapsList sadm;
  long pullRetryPeriod;
  long maxQueueLength;
  long maxEventsPerConsumer;
};

//------------------------------------------------------------------------
// Channel Factory Persistent Data Representation
//------------------------------------------------------------------------
class OEP_cfps
{
public:
  OEP_cfps();
  virtual ~OEP_cfps();

public:
  void setPort(unsigned int port);
  const unsigned int getPort(void) const;
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;
  void addChannel(OEP_ecps *channel);
  OepEcpsList &getChannels(void);

private:
  unsigned int port;
  omniORB::objectKey *key;
  OepEcpsList channels;
};

#endif /* __OEP_TYPES_H_ */

