// -*- Mode: C++; -*-
//                            Package   : omniEvents
// oep_global.h               Created   : 1/10/99
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//

/*
  $Log: oep_global.h,v $
  Revision 1.2  2000/08/30 04:16:57  naderp
  omniORB 3.0.1 Port.
  Added forward declaration for OEP_cfps.

  Revision 1.1  2000/03/06 13:05:23  naderp
  Removed EventChannelFactory dependency on Naming Service.
  Moved port from COMMON to channelFactory.

  Revision 1.0  1999/11/01 16:48:14  naderp
  Initial revision

*/

#ifndef __OEP_GLOBAL_H_
#define __OEP_GLOBAL_H_

class OEP_cfps;

class OEP_GlobalData
{

public:
  // Constructor
  OEP_GlobalData();

  // Destructor
  virtual ~OEP_GlobalData() {};

  // Operations
  virtual long getLineNo();			// Get current line number 
  virtual void setLineNo(long);			// Set current line number
  virtual void incLineNo();			// Increment line number
  virtual void setFactory(OEP_cfps *factory);	// Set factory
  virtual OEP_cfps * getFactory();		// Get factory

private:
  // Data
  long    lineNo;                     // line #
  OEP_cfps *factory;
};

#endif /* __OEP_GLOBAL_H_ */

