// -*- Mode: C++; -*-
//                            Package   : omniEvents
// CosEvent_i.h               Created   : 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//	

/*
  $Log: EventChannelFactory_i.h,v $
  Revision 1.7  2000/10/03 08:36:58  naderp
  *** empty log message ***

  Revision 1.6  2000/09/26 08:42:18  naderp
  Configurable STL default parameters.

  Revision 1.5  2000/09/04 06:17:47  naderp
  Removed std scoping from << operator.

  Revision 1.4  2000/08/30 04:14:50  naderp
  Port to omniORB 3.0.1.
  Changed type omniObjectKey to omniORB::objectKey.

  Revision 1.3  2000/03/06 13:04:01  naderp
  Removed Naming Service dependency.

  Revision 1.2  2000/03/06 04:09:37  naderp
  Removed dependency with Naming Service.
  Remove useless constructor.

  Revision 1.1  1999/11/02 13:40:53  naderp
  Rearranged data member definitions to avoid compiler warnings during
  initialisation.

  Revision 1.0  1999/11/01 16:41:59  naderp
  omniEvents R2.0.
  Added Persistency.
  Added MaxEventsPerConsumer criteria to factory.

 * Revision 0.1  99/08/27  11:50:43  11:50:43  naderp (Paul Nader)
 * Partitioned EventChannelFactory_i from CosEvent_i.
 * 
*/

#ifndef _EVENTCHANNELFACTORY_I_H_
#define _EVENTCHANNELFACTORY_I_H_

#include <omniEvents.h>
#include <EventChannelAdmin.hh>
#include <set>
#ifdef _MSC_VER
using namespace std;
#endif
#ifdef __linux__
#include <signal.h>
#endif

class EventChannel_i;

#ifdef STL_HAS_DEFAULT_ALLOCATOR
typedef set<EventChannel_i *> EventChannelSet;
#else
#ifdef STL_NO_ALLOCATOR_ARGS
#define STL_ALLOCATOR(T) allocator
#else
#define STL_ALLOCATOR(T) allocator<T>
#endif
typedef set<EventChannel_i *,
            less<EventChannel_i *>,
            STL_ALLOCATOR(EventChannel_i *) > EventChannelSet;
#endif

// Event Channel Factory

class EventChannelFactory_i :
  public EventChannelAdmin::_sk_EventChannelFactory {

public:
   EventChannelFactory_i(unsigned int p);
   EventChannelFactory_i(unsigned int p,
                         const omniORB::objectKey &,
			 OepEcpsList &);
   CORBA::Boolean supports (const CosLifeCycle::Key &k);
   CORBA::Object_ptr create_object(const CosLifeCycle::Key &k,
                                   const CosLifeCycle::Criteria &the_criteria);
   friend ostream& operator<<(ostream &, const EventChannelFactory_i &);

private:
   unsigned int port;
   omniORB::objectKey key;
   EventChannelSet eventChannels;
};

#endif /* _EVENTCHANNELFACTORY_I_H_ */
