// -*- Mode: C++; -*-
//                            Package   : omniEvents
// CosEvent_i.h               Created   : 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//	

/*
  $Log: CosEvent_i.h,v $
  Revision 1.6  2000/10/03 08:36:40  naderp
  *** empty log message ***

  Revision 1.5  2000/09/26 08:40:42  naderp
  Configurable STL default parameters.

  Revision 1.4  2000/09/05 01:07:40  naderp
  Added MaxQueueLength QOS.

  Revision 1.3  2000/03/02 03:36:48  naderp
  Changed Proxy containment from channel to admin objects.
  Added Support for multiple admin objects per channel.
  Mulitple bug fixes. See CHANGES_201 file.

  Revision 1.2  1999/11/02 15:17:32  naderp
  Changed maxEventsPerConsumer type to unsigned.

 * Revision 1.1  99/11/02  13:40:11  13:40:11  naderp (Paul Nader)
 * Rearranged data member definitions to avoid compiler warnings during
 * initialisation.
 * 
  Revision 1.0  1999/11/01 16:41:10  naderp
  omniEvents R2.0
  Added Persistency.

 * Revision 0.10  99/08/27  11:49:04  11:49:04  naderp (Paul Nader)
 * Partitioned EventChannelFactory_i from CosEvent_i.
 * 
 * Revision 0.9  99/05/23  14:12:34  14:12:34  naderp (Paul Nader)
 * Changed event channel container conditional declarations to take GNUC
 * versions into account.
 * 
 * Revision 0.8  99/05/10  11:32:05  11:32:05  naderp (Paul Nader)
 * Preliminary SunOS Port.
 * 
 * Revision 0.7  99/05/10  11:28:35  11:28:35  naderp (Paul Nader)
 * Added signal.h for linux.
 * Corrected ProxyPullConsumerSet Declaration.
 * 
 * Revision 0.6  99/04/29  15:48:34  15:48:34  naderp (Paul Nader)
 * Added comparator for set container for architectures that don't
 * support default template arguments.
 * 
 * Revision 0.5  99/04/23  16:13:30  16:13:30  naderp (Paul Nader)
 * *** empty log message ***
 * 
 * Revision 0.4  99/04/23  10:45:44  10:45:44  naderp (Paul Nader)
 * Moved EventChannelAdmin to EventChannelAdmin.idl.
 * 
 * Revision 0.3  99/04/23  09:36:21  09:36:21  naderp (Paul Nader)
 * Windows Port.
 * 
 * Revision 0.2  99/04/21  18:13:38  18:13:38  naderp (Paul Nader)
 * *** empty log message ***
 * 
 * Revision 0.1.1.1  98/12/01  06:07:49  06:07:49  naderp (Paul Nader)
 * Adding Agent Mode Functionality.
 * 
 * Revision 0.1  98/11/25  14:05:34  14:05:34  naderp (Paul Nader)
 * Initial Revision
 * 
*/

#ifndef _COSEVENT_I_H_
#define _COSEVENT_I_H_

#include <omniEvents.h>
#include <CosEventComm.hh>
#include <CosEventChannelAdmin.hh>
#include <set>
#include <list>
#ifdef _MSC_VER
using namespace std;
#endif
#ifdef __linux__
#include <signal.h>
#endif

// Global orb and boa
extern CORBA::ORB_ptr orb;
extern CORBA::BOA_ptr boa;

class event_t;
class ProxyPushConsumer_i;
class ProxyPushSupplier_i;
class ProxyPullConsumer_i;
class ProxyPullSupplier_i;
class SupplierAdmin_i;
class ConsumerAdmin_i;
class EventChannel_i;

#ifdef STL_HAS_DEFAULT_ARGS
typedef list<event_t> EventList;
typedef set<SupplierAdmin_i *> SupplierAdminSet;
typedef set<ConsumerAdmin_i *> ConsumerAdminSet;
typedef set<ProxyPushSupplier_i *> ProxyPushSupplierSet;
typedef set<ProxyPushConsumer_i *> ProxyPushConsumerSet;
typedef set<ProxyPullSupplier_i *> ProxyPullSupplierSet;
typedef set<ProxyPullConsumer_i *> ProxyPullConsumerSet;
#else
#ifdef STL_NO_ALLOCATOR_ARGS
#define STL_ALLOCATOR(T) allocator
#else
#define STL_ALLOCATOR(T) allocator<T>
#endif
typedef list<event_t, STL_ALLOCATOR(event_t) > EventList;
typedef set<SupplierAdmin_i *,
            less<SupplierAdmin_i *>,
            STL_ALLOCATOR(SupplierAdmin_i *) > SupplierAdminSet;
typedef set<ConsumerAdmin_i *,
            less<ConsumerAdmin_i *>,
            STL_ALLOCATOR(ConsumerAdmin_i *) > ConsumerAdminSet;
typedef set<ProxyPushConsumer_i *,
            less<ProxyPushConsumer_i *>,
            STL_ALLOCATOR(ProxyPushConsumer_i *) > ProxyPushConsumerSet;
typedef set<ProxyPushSupplier_i *,
            less<ProxyPushSupplier_i *>,
            STL_ALLOCATOR(ProxyPushSupplier_i *) > ProxyPushSupplierSet;
typedef set<ProxyPushConsumer_i *,
            less<ProxyPushConsumer_i *>,
            STL_ALLOCATOR(ProxyPushConsumer_i *) > ProxyPushConsumerSet;
typedef set<ProxyPullSupplier_i *,
            less<ProxyPullSupplier_i *>,
            STL_ALLOCATOR(ProxyPullSupplier_i *) > ProxyPullSupplierSet;
typedef set<ProxyPullConsumer_i *,
            less<ProxyPullConsumer_i *>,
            STL_ALLOCATOR(ProxyPullConsumer_i *) > ProxyPullConsumerSet;
#endif

class stamp_t {
public:
    stamp_t() {sec = 0; nsec = 0;};
    int operator<=(const stamp_t& lhs) const {return (sec <= lhs.sec);}; 
    void get_time (void) { omni_thread::get_time(&sec, &nsec, 0, 0);};

    int operator == (const stamp_t& s) const {
      return((sec == s.sec) && (nsec == s.nsec));
    }
 
    int operator != (const stamp_t& s) const {
      return((sec != s.sec) || (nsec != s.nsec));
    }
 
    int operator < (const stamp_t& s) const {
      return((sec < s.sec) || ((sec == s.sec) && (nsec < s.nsec)));
    }

    int operator > (const stamp_t& s) const {
      return((sec > s.sec) || ((sec == s.sec) && (nsec > s.nsec)));
    }

public:
    unsigned long sec;
    unsigned long nsec;
};


class event_t {
public:
    int operator == (const event_t& e) const {
      return(stamp == e.stamp);
    }

    int operator != (const event_t& e) const {
      return(stamp != e.stamp);
    }

    int operator < (const event_t& e) const {
      return(stamp < e.stamp);
    }

    int operator > (const event_t& e) const {
      return(stamp > e.stamp);
    }

public:
    CORBA::Any data;
    stamp_t stamp;
};

// PUSH
//------------------------------------------------------------------------
class ProxyPushConsumer_i;
typedef ProxyPushConsumer_i* ProxyPushConsumerImpl_ptr;

class ProxyPushConsumer_i :
  virtual public CosEventComm::_sk_PushConsumer,
  virtual public CosEventChannelAdmin::_sk_ProxyPushConsumer {

public:
    ProxyPushConsumer_i (SupplierAdmin_i *admin);
    ProxyPushConsumer_i (SupplierAdmin_i *admin, const omniORB::objectKey &k, const char *ior = NULL);
    virtual ~ProxyPushConsumer_i ();
    void connect_push_supplier (CosEventComm::PushSupplier_ptr push_supplier);
    void push (const CORBA::Any& data);
    void disconnect_push_consumer ();
    friend ostream& operator<<(ostream &, const ProxyPushConsumer_i &);

private:
    omniORB::objectKey key;
    omni_mutex      _lock;
    SupplierAdmin_i *admin;
    CosEventComm::PushSupplier_ptr _supplier;
    enum {notConnected, connected, disconnected} _proxyState;
};

//------------------------------------------------------------------------
class ProxyPushSupplier_i;
typedef ProxyPushSupplier_i* ProxyPushSupplierImpl_ptr;

class ProxyPushSupplier_i :
  virtual public CosEventComm::_sk_PushSupplier,
  virtual public CosEventChannelAdmin::_sk_ProxyPushSupplier {

public:
    ProxyPushSupplier_i (ConsumerAdmin_i *admin);
    ProxyPushSupplier_i (ConsumerAdmin_i *admin, const omniORB::objectKey &k, const char *ior = NULL);
    virtual ~ProxyPushSupplier_i();
    void connect_push_consumer (CosEventComm::PushConsumer_ptr push_consumer);
    void disconnect_push_supplier ();
    void setMaxEvents(unsigned long);
    friend ostream& operator<<(ostream &, const ProxyPushSupplier_i &);

private:
    void dispatch(void);
    void addEvent (const event_t &event);
    friend class ConsumerAdmin_i;

private:
    omni_condition                 _nonEmpty;
    omniORB::objectKey             key;
    unsigned long                  _maxEvents;
    stamp_t                        _stamp;
    omni_mutex                     _lock;
    omni_mutex                     _headLock;
    omni_thread                   *_dispatcher;
    EventList                      _events;
    ConsumerAdmin_i                *admin;
    CosEventComm::PushConsumer_ptr _consumer;
    enum {notConnected, connected, disconnected} _proxyState;
};


class ProxyPushSupplierWorker : public omni_thread {

public:
    typedef void (ProxyPushSupplier_i::*Method)(void);
    ProxyPushSupplierWorker(ProxyPushSupplier_i *object,
                            Method method,
                            priority_t priority = PRIORITY_NORMAL);
    void* run_undetached(void *);
    virtual ~ProxyPushSupplierWorker();

private:
    ProxyPushSupplier_i* _object;
    Method _method;
    ProxyPushSupplierWorker();
};

// PULL
//------------------------------------------------------------------------
class ProxyPullSupplier_i;
typedef ProxyPullSupplier_i* ProxyPullSupplierImpl_ptr;

class ProxyPullSupplier_i :
  virtual public CosEventChannelAdmin::_sk_ProxyPullSupplier {

public:
    ProxyPullSupplier_i (ConsumerAdmin_i *admin);
    ProxyPullSupplier_i (ConsumerAdmin_i *admin, const omniORB::objectKey &k, const char *ior = NULL);
    virtual ~ProxyPullSupplier_i();
    void connect_pull_consumer (CosEventComm::PullConsumer_ptr pull_consumer);
    void disconnect_pull_supplier ();
    CORBA::Any* pull ();
    CORBA::Any* try_pull (CORBA::Boolean &has_event);
    void setMaxEvents(unsigned long);
    friend ostream& operator<<(ostream &, const ProxyPullSupplier_i &);

private:
    void addEvent (const event_t &event);
    friend class ConsumerAdmin_i;

private:
    omni_condition                 _nonEmpty;
    unsigned long                  _maxEvents;
    omniORB::objectKey             key;
    stamp_t                        _stamp;
    omni_mutex                     _lock;
    omni_mutex                     _headLock;
    EventList                      _events;
    ConsumerAdmin_i                *admin;
    CosEventComm::PullConsumer_ptr _consumer;
    enum {notConnected, connected, disconnected} _proxyState;
};


//------------------------------------------------------------------------
class ProxyPullConsumer_i;
typedef ProxyPullConsumer_i* ProxyPullConsumerImpl_ptr;

class ProxyPullConsumer_i :
  virtual public CosEventComm::_sk_PullConsumer,
  virtual public CosEventChannelAdmin::_sk_ProxyPullConsumer {

public:
    ProxyPullConsumer_i (SupplierAdmin_i *admin);
    ProxyPullConsumer_i (SupplierAdmin_i *admin, const omniORB::objectKey &k, const char *ior = NULL);
    virtual ~ProxyPullConsumer_i();
    void connect_pull_supplier (CosEventComm::PullSupplier_ptr pull_supplier);
    void disconnect_pull_consumer ();
    friend ostream& operator<<(ostream &, const ProxyPullConsumer_i &);

private:
    event_t *getEvent(CORBA::Boolean &has_event);
    friend class SupplierAdmin_i;

private:
    omniORB::objectKey key;
    omni_mutex      _lock;
    SupplierAdmin_i *admin;
    CosEventComm::PullSupplier_ptr _supplier;
    enum {notConnected, connected, disconnected} _proxyState;
};


//------------------------------------------------------------------------
// CONSUMER ADMIN

class ConsumerAdmin_i :
  public CosEventChannelAdmin::_sk_ConsumerAdmin {

public: 
    ConsumerAdmin_i (EventChannel_i *ec);
    ConsumerAdmin_i (EventChannel_i *ec, const omniORB::objectKey &k,  const OEP_caps &);
    virtual ~ConsumerAdmin_i ();
    CosEventChannelAdmin::ProxyPushSupplier_ptr obtain_push_supplier ();
    CosEventChannelAdmin::ProxyPullSupplier_ptr obtain_pull_supplier ();
    void addEvent (const event_t &event);
    void reqEvent (void);
    void destroy ();
    friend ostream& operator<<(ostream &, ConsumerAdmin_i &);

private:
    // Proxy Registration
    void _reg_pxy_push_supplier (ProxyPushSupplier_i *);
    void _reg_pxy_pull_supplier (ProxyPullSupplier_i *);

    // Proxy De-Registration
    void _drg_pxy_push_supplier (ProxyPushSupplier_i *);
    void _drg_pxy_pull_supplier (ProxyPullSupplier_i *);

    // Friends
    friend class ProxyPushSupplier_i; 
    friend class ProxyPullSupplier_i; 

private:

    // List of Proxies
    ProxyPushSupplierSet _pxy_push_supp;         // List of ProxyPushSuppliers
    omni_mutex proxyPushSuppliersLock;           // ProxyPushSuppliers Lock
    ProxyPullSupplierSet _pxy_pull_supp;         // List of ProxyPullSuppliers
    omni_mutex proxyPullSuppliersLock;           // ProxyPushSuppliers Lock

    omni_mutex lock;
    EventList _events;
    omniORB::objectKey key;
    EventChannel_i* channel;
};

//------------------------------------------------------------------------
// SUPPLIER ADMIN

class SupplierAdmin_i :
  public CosEventChannelAdmin::_sk_SupplierAdmin {

public: 
    SupplierAdmin_i (EventChannel_i *ec);
    SupplierAdmin_i (EventChannel_i *ec, const omniORB::objectKey &k,  const OEP_saps &);
    virtual ~SupplierAdmin_i ();
    CosEventChannelAdmin::ProxyPushConsumer_ptr obtain_push_consumer ();
    CosEventChannelAdmin::ProxyPullConsumer_ptr obtain_pull_consumer ();
    void addEvent (const event_t &event);
    event_t *getEvent(CORBA::Boolean &has_event);
    void destroy ();
    friend ostream& operator<<(ostream &, SupplierAdmin_i &);

private:
    // Proxy Registration
    void _reg_pxy_push_consumer (ProxyPushConsumer_i *);
    void _reg_pxy_pull_consumer (ProxyPullConsumer_i *);

    // Proxy De-Registration
    void _drg_pxy_push_consumer (ProxyPushConsumer_i *);
    void _drg_pxy_pull_consumer (ProxyPullConsumer_i *);

    // Friends
    friend class ProxyPushConsumer_i; 
    friend class ProxyPullConsumer_i; 

private:
    // List of Proxies
    ProxyPushConsumerSet _pxy_push_cons;         // List of ProxyPushConsumers
    omni_mutex proxyPushConsumersLock;           // ProxyPushConsumers Lock
    ProxyPullConsumerSet _pxy_pull_cons;         // List of ProxyPushConsumers
    omni_mutex proxyPullConsumersLock;           // ProxyPushConsumers Lock

    omni_mutex lock;
    EventList _events;
    omniORB::objectKey key;
    EventChannel_i* channel;
};

//------------------------------------------------------------------------
// EVENT CHANNEL

class EventChannel_i :
  public CosEventChannelAdmin::_sk_EventChannel {

public:
    EventChannel_i ();
    EventChannel_i(const omniORB::objectKey &, const OEP_ecps &);
    virtual ~EventChannel_i ();

    void setPullRetryPeriod(long);
    long getPullRetryPeriod(void) const;
    void setMaxQueueLength(unsigned long);
    unsigned long getMaxQueueLength(void) const;
    void setMaxEventsPerConsumer(unsigned long);
    unsigned long getMaxEventsPerConsumer(void) const;
    void enable(void);

    CosEventChannelAdmin::ConsumerAdmin_ptr for_consumers ();
    CosEventChannelAdmin::SupplierAdmin_ptr for_suppliers ();
    void destroy ();
    friend ostream& operator<<(ostream &, EventChannel_i &);

    // Proxy Tracking
    typedef enum {ProxyPushSupplier, ProxyPushConsumer,
                  ProxyPullSupplier, ProxyPullConsumer} proxy_t;
    void incProxies(const proxy_t &proxy);
    void decProxies(const proxy_t &proxy);

private:
    // Admin Object Registration
    void _reg_supplier_admin (SupplierAdmin_i *);
    void _reg_consumer_admin (ConsumerAdmin_i *);

    // Admin Object De-Registration
    void _drg_supplier_admin (SupplierAdmin_i *);
    void _drg_consumer_admin (ConsumerAdmin_i *);

    void addEvent (const event_t &event);
    void reqEvent (void);
    
    friend class SupplierAdmin_i;
    friend class ConsumerAdmin_i;
    friend class EventChannelWorker;

private:
    int agentMode(void);
    void _agent(void);
    void _pull(void);
    void dispatch(void);

    // Thread Synchronisation
    omni_mutex _lock;
    omni_mutex _headLock;
    omni_condition *_nonEmpty;

    unsigned long maxQueueLength;          // QOS Max Events Queued by Channel.
    unsigned long _maxEventsPerConsumer;   // QOS Max Events Queued by Cons Pxy.
    long _pullRetryPeriod;                 // QOS Pull Retry Period.
    omni_thread *dispatchThread;           // Dispatch Thread.
    omni_thread *agentThread;              // Agent Thread.
    omni_thread *pullThread;               // Pull Thread.
    omni_semaphore agentSemaphore;         // Agent Semaphore.
    omni_semaphore pullSemaphore;          // Pull Semaphore.
    unsigned long pushSuppliers;           // No of Connected Push Suppliers.
    unsigned long pushConsumers;           // No of Connected Push Consmuers.
    unsigned long pullSuppliers;           // No of Connected Pull Suppliers.
    unsigned long pullConsumers;           // No of Connected Pull Consumers.
    omni_mutex clientCounterLock;          // Channel Client Counter Lock.
    SupplierAdminSet supplierAdmins;       // List of Supplier Admins.
    omni_mutex supplierAdminsLock;         // Supplier Admins Lock
    ConsumerAdminSet consumerAdmins;       // List of Consumer Admins.
    omni_mutex consumerAdminsLock;         // Consumer Admins Lock
    omniORB::objectKey key;                // Object Key.
    EventList _events;                     // Event Queue.
};

class EventChannelWorker : public omni_thread {

public:
    typedef void (EventChannel_i::*Method)(void);
 
public:
    EventChannelWorker(EventChannel_i &object,
                      Method method,
                      priority_t priority = PRIORITY_NORMAL);
    void run(void *);

private:
    EventChannel_i* _object;
    Method _method;
    EventChannelWorker() {};
};

#endif /* _COSEVENT_I_H_ */
