// -*- Mode: C++; -*-
//                            Package   : omniEvents
// oep_global.cc              Created   : 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//

/*
  $Log: oep_global.cc,v $
  Revision 1.1  2000/03/06 13:12:59  naderp
  Added port data member and accessors.

  Revision 1.0  1999/11/01 16:29:25  naderp
  Initial revision

*/

#include <omniEvents.h>

OEP_GlobalData::OEP_GlobalData()
   : lineNo(0),
     factory(NULL)
{
  // empty
} 

void
OEP_GlobalData::setLineNo(long n)
{
  lineNo = n;
}

long
OEP_GlobalData::getLineNo()
{
  return lineNo;
}

void
OEP_GlobalData::incLineNo()
{
  lineNo++;
}

void
OEP_GlobalData::setFactory(OEP_cfps *f)
{
  if (factory != NULL)
  {
    delete factory;
  }

  factory = f;
}

OEP_cfps *
OEP_GlobalData::getFactory()
{
  return factory;
}
