#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

include ../config/config.mk

EXPORT_TREE     = ..

CXXSRCS		= y.tab.cc \
		  lex.yy.cc \
		  oep_types.cc \
		  oep_global.cc \
		  chkfmt.cc

CXXOBJS		= ../util/args.o \
		  y.tab.o \
		  lex.yy.o \
		  oep_types.o \
		  oep_global.o \
		  chkfmt.o

ifdef STL_INCLUDE_PATH
DIR_CPPFLAGS    += -I$(STL_INCLUDE_PATH)
endif

ifdef STL_HAS_DEFAULT_ARGS
DIR_CPPFLAGS	+= -DSTL_HAS_DEFAULT_ARGS
else
ifdef STL_NO_ALLOCATOR_ARGS
DIR_CPPFLAGS	+= -DSTL_NO_ALLOCATOR_ARGS
endif
endif

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

CXXOBJS		+= ../util/getopt.o
DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS)

ifdef STL_LIBRARY_PATH
IMPORT_LIBRARY_FLAGS += -libpath:$(STL_LIBRARY_PATH)
endif

else

#############################################################################
#   Make variables for Unix platforms                                       #
#############################################################################

DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES

ifdef STL_LIBRARY_PATH
IMPORT_LIBRARY_DIRS += $(STL_LIBRARY_PATH)
endif

ifdef STL_LIBRARY_NAME
STL_LIB = $(patsubst %, $(LibSearchPattern), $(STL_LIBRARY_NAME))
endif

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

chkfmt		= $(patsubst %,$(BinPattern),chkfmt)

EXECS		= $(chkfmt)

all:: $(EXECS)

clean::
	$(RM) $(EXECS) $(CXXOBJS) *.d

$(chkfmt): $(CXXOBJS) $(lib)
	@(libs="$(CORBA_LIB) $(STL_LIB)"; $(CXXExecutable))

export:: $(chkfmt)
	@$(ExportExecutable)

#
# Create the parser and lexer
#
# If ever we need to regenerate lex.yy.cc and y.tab.cc, use bison and flex
#
#lex.yy.cc: oep.ll
#	@-$(RM) $@
#	flex -B $<
#	sed -e 's/^#include <unistd.h>//' lex.yy.c > $@
#	rm -f lex.yy.c
#	echo '#ifdef __VMS' >> $@
#	echo '// Some versions of DEC C++ for OpenVMS set the module name used by the'>>$@
#	echo '// librarian based on the last #line encountered.' >> $@
#	echo '#line' `cat $@ | wc -l` '"lex_yy.cc"' >> $@
#	echo '#endif' >> $@
#
#y.tab.cc: oep.yy
#	@-$(RM) $@
#	bison -d -y $<
#	mv -f y.tab.c y.tab.cc
#	echo '#ifdef __VMS' >> $@
#	echo '// Some versions of DEC C++ for OpenVMS set the module name used by the'>>$@
#	echo '// librarian based on the last #line encountered.' >> $@
#	echo '#line' `cat $@ | wc -l` '"y_tab.cc"' >> $@
#	echo '#endif' >> $@
#
