// -*- Mode: C++; -*-
//                            Package   : omniEvents
//   pushsupp.cc              Created on: 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omnievents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//    Push Model supplier implementation.
//	

/*
  $Log: pushsupp.cc,v $
  Revision 0.14  2000/10/11 01:16:21  naderp
  *** empty log message ***

  Revision 0.13  2000/08/30 04:39:48  naderp
  Port to omniORB 3.0.1.

  Revision 0.12  2000/03/16 05:37:27  naderp
  Added stdlib.h for getopt.

  Revision 0.11  2000/03/06 13:27:10  naderp
  Using util getRootNamingContext function.
  Using stub headers.
  Fixed error messages.

  Revision 0.10  2000/03/02 03:21:20  naderp
  Added -r option to connect using nil reference.
  Added retry resiliency for handling COMM_FAUILURE exceptions.

Revision 0.9  99/11/02  13:39:17  13:39:17  naderp (Paul Nader)
Added <signal.h>

  Revision 0.8  1999/11/02 07:57:18  naderp
  Updated usage.

Revision 0.7  99/11/01  19:22:43  19:22:43  naderp (Paul Nader)
Added catch for COMM_FAILURE exception in obtain_push_consumer
and disconnect_push_consumer calls.

Revision 0.6  99/11/01  16:12:03  16:12:03  naderp (Paul Nader)
omniEvents 2.0 Release.

Revision 0.5  99/10/27  19:42:31  19:42:31  naderp (Paul Nader)
Ignoring Unix SIGPIPE signal.
Reporting sleep beforhand.

Revision 0.4  99/04/23  16:05:47  16:05:47  naderp (Paul Nader)
gcc port.

Revision 0.3  99/04/23  09:34:04  09:34:04  naderp (Paul Nader)
Windows Port.

Revision 0.2  99/04/21  18:06:26  18:06:26  naderp (Paul Nader)
*** empty log message ***

Revision 0.1.1.1  98/11/27  16:59:40  16:59:40  naderp (Paul Nader)
Added -s option to sleep after disconnecting.

Revision 0.1  98/11/25  14:08:25  14:08:25  naderp (Paul Nader)
Initial Revision

*/

//
//
#include <CosEventComm.hh>
#include <CosEventChannelAdmin.hh>
#ifdef __WIN32__
#include <getopt.h>
#include <iostream>
using namespace std;
#else
#include <stdlib.h>
#include <unistd.h>
#include <iostream.h>
#include <signal.h>
#endif

#ifndef true
#define true 1
#endif

#ifndef false
#define false 0
#endif

static void usage();
extern CosNaming::NamingContext_ptr getRootNamingContext(CORBA::ORB_ptr orb);

class Supplier_i : virtual public CosEventComm::_sk_PushSupplier {
public:
  Supplier_i () {};
  void disconnect_push_supplier ();
};

void
Supplier_i::disconnect_push_supplier () {
  cout << "EventSupplier: disconnected." << endl;
}

int main (int argc, char** argv)
{
  long l = 0;
  CORBA::ORB_var orb = CORBA::ORB_init (argc, argv, "omniORB3");
  CORBA::BOA_var boa = orb->BOA_init (argc, argv, "omniORB3_BOA");

  // Process Options
  int c;
  int discnum = 0;
  int refnil = false;
  int sleepInterval = 0;
  char *channelName = (char *) "EventChannel";
  char *channelKind = (char *) "EventChannel";
  while ((c = getopt(argc,argv,"d:rs:n:k:h")) != EOF)
  {
     switch (c)
     {
        case 'd': discnum = atoi(optarg);
                  break;

        case 'r': refnil = true;
                  break;

        case 's': sleepInterval = atoi(optarg);
                  break;

        case 'n': channelName = optarg;
                  break;

        case 'k': channelKind = optarg;
                  break;

        case 'h':
        default : usage();
                  exit(-1);
                  break;
     }
  }

  // Ignore broken pipes
#ifndef __WIN32__
  signal(SIGPIPE, SIG_IGN);
#endif

  Supplier_i* supplier = new Supplier_i ();
  supplier->_obj_is_ready(boa);

  // A Push Supplier can be implemented as a pure client or as a mixed
  // client-server process, depending on whether it requires and is
  // prepared to service disconnect requests from the channel.
  // If its is then let the BOA know we are ready without blocking.
  if (! refnil)
  {
     boa->impl_is_ready(0,1);
  }
   
  CosNaming::NamingContext_var rootContext;
  rootContext = getRootNamingContext(orb);

  // Obtain Event Channel Object.
  CosNaming::Name name;
  name.length (1);
  name[0].id = CORBA::string_dup (channelName);
  name[0].kind = CORBA::string_dup (channelKind);

  cout << "Looking for EventChannel" << endl;
  CosEventChannelAdmin::EventChannel_var event_channel;
  try {
    CORBA::Object_var obj = rootContext->resolve (name);
    event_channel = CosEventChannelAdmin::EventChannel::_narrow (obj);
    if (CORBA::is_nil (event_channel))
    {
       cerr << "Failed to narrow Event Channel !" << endl;
       exit(1);
    }
  }
  catch (CORBA::ORB::InvalidName& ex) {
     cerr << "Service required is invalid [does not exist]. !" << endl;
     exit(1);
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught COMM_FAILURE exception. "
          << "Unable to contact the naming service !"
          << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception !" << endl;
     throw;
  }
  catch (...) {
     cerr << "Cannot find event channel ! [\""
          << channelName << "\", \"" << channelKind << "\"]"
          << endl;
     exit(1);
  }

  //
  // Get Supplier Admin interface - retrying on Comms Failure.
  CosEventChannelAdmin::SupplierAdmin_var supplier_admin;
  while (1)
  {
     try {
        supplier_admin = event_channel->for_suppliers ();
        if (CORBA::is_nil(supplier_admin))
        {
           cerr << "Event Channel returned nil Supplier Admin !."
                << endl;
           exit(1);
        }
        break;
     }
     catch (CORBA::COMM_FAILURE& ex) {
        cerr << "Caught COMM_FAILURE Exception "
             << "obtaining Supplier Admin !. Retrying..."
             << endl;
        continue;
     }
     catch (...) {
        cerr << "Unexpected System Exeption. "
             << "Failed to obtain Supplier Admin !"
             << endl;
        exit(1);
     }
  }
  cerr << "Obtained SupplierAdmin." << endl;

  while (1)
  {
     //
     // Get proxy consumer - retrying on Comms Failure.
     CosEventChannelAdmin::ProxyPushConsumer_var proxy_consumer;
     while (1)
     {
        try {
           proxy_consumer = supplier_admin->obtain_push_consumer ();
           if (CORBA::is_nil(proxy_consumer))
           {
              cerr << "Supplier Admin return nil proxy_consumer !."
                   << endl;
              exit(1);
           }
           break;
        }
        catch (CORBA::COMM_FAILURE& ex) {
           cerr << "Caught COMM_FAILURE Exception "
                << "obtaining Push Consumer !. Retrying..."
                << endl;
           continue;
        }
        catch (...) {
           cerr << "Unexpected System Exeption. "
                << "Failed to obtain Proxy Consumer !"
                << endl;
           exit(1);
        }
     }
     cerr << "Obtained ProxyPushConsumer." << endl;
   
     //
     // Connect Push Supplier - retrying on Comms Failure.
     CosEventComm::PushSupplier_ptr sptr;
     sptr = supplier->_this();
     sptr = (! refnil) ? CosEventComm::PushSupplier::_duplicate(sptr)
                       : CosEventComm::PushSupplier::_nil();
     while (1)
     {
        try {
           proxy_consumer->connect_push_supplier(sptr);
           break;
        }
        catch (CORBA::BAD_PARAM& ex) {
           cerr << "Caught BAD_PARAM Exception connecting Push Supplier !"
                << endl;
           exit (1);
        }
        catch (CosEventChannelAdmin::AlreadyConnected& ex) {
           cerr << "Pull Supplier already connected !"
                << endl;
           break;
        }
        catch (CORBA::COMM_FAILURE& ex) {
           cerr << "Caught COMM_FAILURE Exception "
                << "connecting Push Supplier !. Retrying..."
                << endl;
           continue;
        }
        catch (...) {
           cerr << "Unexpected System Exception. "
                << "Failed to connect Push Supplier !"
                << endl;
           exit (1);
        }
     }
     cerr << "Connected Push Supplier." << endl;
   
     // Push data.
     for (int i=0; (discnum == 0) || (i < discnum); i++)
     {
        CORBA::Any any;
        any <<= (CORBA::ULong) l++;
        try {
           cout << "Push Supplier: push() called. ";
           proxy_consumer->push(any);
           cout << "Data : " << l-1 << endl;
        }
        catch (...) {
           cout << "Failed !" << endl;
        }
     }
   
     // Disconnect - retrying on Comms Failure.
     while (1)
     {
        try {
           proxy_consumer->disconnect_push_consumer();
           break;
        }
        catch (CORBA::COMM_FAILURE& ex) {
           cerr << "Caught COMM_FAILURE Exception "
                << "disconnecting Push Supplier!. Retrying..."
                << endl;
           continue;
        }
        catch (...) {
           cerr << "Unexpected System Exception. "
                << "Failed to disconnect Push Supplier!"
                << endl;
           exit(1);
        }
     }
     cerr << "ProxyPushConsumer disconnected." << endl;

     // Yawn.
     cerr << "Sleeping " << sleepInterval << " Seconds." << endl;
     omni_thread::sleep(sleepInterval);
  }

  // Not Reached
  return 0;
}

static void
usage()
{
   cerr << "\nusage: pushsupp [-d n [-s n]] [-n name] [-k kind] [-h]\n" << endl;
   cerr << "         -d n   disconnect after n pushes" << endl;
   cerr << "         -r     connect using nil reference" << endl;
   cerr << "         -s n   sleep n seconds after disconnecting" << endl;
   cerr << "         -n name specify channel name [\"EventChannel\"]" << endl;
   cerr << "         -k kind specify channel kind [\"EventChannel\"]" << endl;
   cerr << "         -h     display usage" << endl;
   cerr << endl;
}
