// -*- Mode: C++; -*-
//                            Package   : omniEvents
// pullcons.cc                Created on: 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//    Pull Model consumer implementation.
//	

/*
  $Log: pullcons.cc,v $
  Revision 0.11  2000/10/11 01:16:21  naderp
  *** empty log message ***

  Revision 0.10  2000/08/30 04:39:48  naderp
  Port to omniORB 3.0.1.

  Revision 0.9  2000/03/16 05:37:27  naderp
  Added stdlib.h for getopt.

  Revision 0.8  2000/03/06 13:25:44  naderp
  Using util getRootNamingContext function.
  Using stub headers.
  Fixed error messages.

  Revision 0.7  2000/03/02 02:11:27  naderp
  Added -r option to connect using nil reference.
  Added retry resiliency for handling COMM_FAUILURE exceptions.

  Revision 0.6  1999/11/02 13:38:57  naderp
  Added <signal.h>

  Revision 0.5  1999/11/01 15:55:11  naderp
  omniEvents 2.0 Release.
  Ignoring SIGPIPE for UNIX platforms.

Revision 0.4  99/04/23  16:05:38  16:05:38  naderp (Paul Nader)
gcc port.

Revision 0.3  99/04/23  09:33:40  09:33:40  naderp (Paul Nader)
Windows Port.

Revision 0.2  99/04/21  18:06:25  18:06:25  naderp (Paul Nader)
*** empty log message ***

Revision 0.1.1.1  98/11/27  16:59:07  16:59:07  naderp (Paul Nader)
Added -s option to sleep after disconnecting.

Revision 0.1  98/11/25  14:08:04  14:08:04  naderp (Paul Nader)
Initial Revision

*/

//
//
#include <CosEventComm.hh>
#include <CosEventChannelAdmin.hh>
#ifdef __WIN32__
#include <getopt.h>
#include <iostream>
using namespace std;
#else
#include <stdlib.h>
#include <unistd.h>
#include <iostream.h>
#include <signal.h>
#endif

#ifndef true
#define true 1
#endif

#ifndef false
#define false 0
#endif

static void usage();
extern CosNaming::NamingContext_ptr getRootNamingContext(CORBA::ORB_ptr orb);

class Consumer_i : virtual public CosEventComm::_sk_PullConsumer {
public:
  Consumer_i () {};
  void disconnect_pull_consumer ();
};

void Consumer_i::disconnect_pull_consumer () {
  cout << "EventConsumer: disconnected." << endl;
}

int
main(int argc, char **argv)
{
  //
  // Start orb and boa.
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB3");
  CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB3_BOA");

  // Process Options
  int c;
  int trymode = false;
  int discnum = 0;
  int refnil = false;
  int sleepInterval = 0;
  char *channelName = (char *) "EventChannel";
  char *channelKind = (char *) "EventChannel";
  while ((c = getopt(argc,argv,"td:rs:n:k:h")) != EOF)
  {
     switch (c)
     {
        case 't': trymode = true;
                  break;

        case 'd': discnum = atoi(optarg);
                  break;

        case 'r': refnil = true;
                  break;

        case 's': sleepInterval = atoi(optarg);
                  break;

        case 'n': channelName = optarg;
                  break;

        case 'k': channelKind = optarg;
                  break;

        case 'h':
        default : usage();
                  exit(-1);
                  break;
     }
  }
  
  // Ignore broken pipes
#ifndef __WIN32__
  signal(SIGPIPE, SIG_IGN);
#endif

  Consumer_i* consumer = new Consumer_i ();
  consumer->_obj_is_ready(boa);

  // A Pull Consumer can be implemented as a pure client or as a mixed
  // client-server process, depending on whether it requires and is
  // prepared to service disconnect requests from the channel.
  // If its is then let the BOA know we are ready without blocking.
  if (! refnil)
  {
     boa->impl_is_ready(0,1);
  }

  //
  // Obtain and narrow reference to Name Service.
  CosNaming::NamingContext_ptr rootContext;
  rootContext = getRootNamingContext(orb);

  // Obtain Event Channel Object.
  CosNaming::Name name;
  name.length (1);
  name[0].id = CORBA::string_dup (channelName);
  name[0].kind = CORBA::string_dup (channelKind);

  cout << "Looking for EventChannel" << endl;
  CosEventChannelAdmin::EventChannel_var channel;
  try {
    CORBA::Object_var obj = rootContext->resolve(name);
    channel = CosEventChannelAdmin::EventChannel::_narrow(obj);
    if (CORBA::is_nil(channel))
    {
       cerr << "Failed to narrow Event Channel reference !" << endl;
       exit(1);
    }
  }
  catch (CORBA::ORB::InvalidName& ex) {
     cerr << "Service required is invalid [does not exist]. !" << endl;
     exit(1);
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE, unable to contact the "
          << "naming service !" << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception !" << endl;
     throw;
  }
  catch (...) {
     cerr << "Cannot find event channel ! [\""
          << channelName << "\", \"" << channelKind << "\"]"
          << endl;
     exit (1);
  }

  //
  // Get Consumer admin interface - retrying on Comms Failure.
  CosEventChannelAdmin::ConsumerAdmin_var consumer_admin;
  while (1)
  {
     try {
        consumer_admin = channel->for_consumers ();
        if (CORBA::is_nil (consumer_admin))
        {
           cerr << "Event Channel returned nil Consumer Admin !."
                << endl;
           exit (1);
        }
        break;
     }
     catch (CORBA::COMM_FAILURE& ex) {
        cerr << "Caught COMM_FAILURE Exception "
             << "obtaining COnsumer Admin !. Retrying..."
             << endl;
        continue;
     }
     catch (...) {
        cerr << "Unexpected System Exception. "
             << "Failed to obtain Consumer Admin !."
             << endl;
        exit(1);
     }
  }
  cerr << "Obtained Consumer Admin." << endl;

  while (1)
  {
     //
     // Get proxy supplier - retrying on Comms Failure.
     CosEventChannelAdmin::ProxyPullSupplier_var proxy_supplier;
     while (1)
     {
        try {
           proxy_supplier = consumer_admin->obtain_pull_supplier ();
           if (CORBA::is_nil (proxy_supplier))
           {
              cerr << "Consumer Admin returned nil Proxy Supplier !."
                   << endl;
              exit (1);
           }
           break;
        }
        catch (CORBA::COMM_FAILURE& ex) {
           cerr << "Caught COMM_FAILURE Exception "
                << "obtaining Pull Supplier !. Retrying..."
                << endl;
           continue;
        }
        catch (...) {
           cerr << "Unexpected System Exception. "
                << "Failed to obtain Proxy Supplier !"
                << endl;
           exit (1);
        }
     }
     cerr << "Obtained ProxyPullSupplier." << endl;
   
     //
     // Connect Pull Consumer - retrying on Comms Failure.
     CosEventComm::PullConsumer_ptr cptr;
     cptr = consumer->_this();
     cptr = (! refnil) ? CosEventComm::PullConsumer::_duplicate(cptr)
                       : CosEventComm::PullConsumer::_nil();
     while (1)
     {
        try {
           proxy_supplier->connect_pull_consumer(cptr);
           break;
        }
        catch (CORBA::BAD_PARAM& ex) {
           cerr << "Caught BAD_PARAM Exception connecting Pull Consumer !"
                << endl;
           exit (1);
        }
        catch (CosEventChannelAdmin::AlreadyConnected& ex) {
           cerr << "Pull Consumer already connected !" 
                << endl;
           break;
        }
        catch (CORBA::COMM_FAILURE& ex) {
           cerr << "Caught COMM_FAILURE Exception "
                << "connecting Pull Consumer !. Retrying..." 
                << endl;
           continue;
        }
        catch (...) {
           cerr << "Unexpected System Exception."
                << "Failed to connect Pull Consumer !"
                << endl;
           exit (1);
        }
     }
     cerr << "Connected Pull Consumer." << endl;

     // Pull data.
     CORBA::Any *data;
     CORBA::ULong l = 0;
     for (int i=0; (discnum == 0) || (i < discnum); i++)
     {
        if (!trymode)
        {
           try {
               cout << "Pull Consumer: pull () called. ";
               data = proxy_supplier->pull();
               l = 0;
               *data >>= l;
               cout << "Data : " << l << endl;
               delete data;
           }
           catch (CosEventComm::Disconnected& ex) {
              cerr << "Failed. Caught Disconnected Exception !" 
                   << endl;
           }
           catch (CORBA::COMM_FAILURE& ex) {
              cerr << "Failed. Caught COMM_FAILURE Exception !" 
                   << endl;
           }
           catch (...)
           {
               cerr << "Failed. Caught Unknown Exception !" << endl;
           }
        }
        else
        {
           try {
               CORBA::Boolean has_event;
               data = proxy_supplier->try_pull(has_event);
               cout << "Consumer: try_pull () called. Data : " << flush;
               if (has_event)
               {
                  l = 0;
                  *data >>= l;
                  cout << l << endl;
                  delete data;
               }
               else
               {
                  cout << "No Data" << endl;
   
               }
           }
           catch (CosEventComm::Disconnected& ex) {
              cerr << "Failed. Caught Disconnected Exception !" 
                   << endl;
           }
           catch (CORBA::COMM_FAILURE& ex) {
              cerr << "Failed. Caught COMM_FAILURE Exception !" 
                   << endl;
           }
           catch (...)
           {
               cerr << "Failed. Caught Unknown Exception !" << endl;
           }
        }
     }

     // Disconnect - retrying on Comms Failure.
     while (1)
     {
        try {
           proxy_supplier->disconnect_pull_supplier();
           break;
        }
        catch (CORBA::COMM_FAILURE& ex) {
           cerr << "Caught COMM_FAILURE exception "
                << "disconnecting Pull Consumer !. Retrying..." 
                << endl;
           continue;
        }
        catch (...) {
           cerr << "Unexpected System Exception."
                << "Failed to disconnect Pull Consumer !."
                << endl;
           exit(1);
        }
     }
     cerr << "Disconnected Pull Consumer." << endl;

     // Yawn
     cerr << "Sleeping " << sleepInterval << " Seconds." << endl;
     omni_thread::sleep(sleepInterval);
  }

  // Not Reached
  return 0;
}

static void
usage()
{
   cerr << "\nusage: pullcons [-t] [-d n [-s n]] [-n name] [-k kind] [-h]\n" << endl;
   cerr << "         -t      enable try_pull mode" << endl;
   cerr << "         -r      connect using nil reference" << endl;
   cerr << "         -d n    disconnect after n pulls" << endl;
   cerr << "         -s n    sleep n Seconds after disconnecting " << endl;
   cerr << "         -n name specify channel name [\"EventChannel\"]" << endl;
   cerr << "         -k kind specify channel kind [\"EventChannel\"]" << endl;
   cerr << "         -h     display usage" << endl;
   cerr << endl;
}
