// -*- Mode: C++; -*-
//                            Package   : omniEvents
// oep_types.h                Created   : 1/10/99
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//

/*
  $Log: oep_types.h,v $
  Revision 1.3  2000/03/06 13:06:53  naderp
  Removed EventChannelFactory dependency with Naming Service.
  Moved port from COMMON to channelFactory.

  Revision 1.2  2000/03/02 03:41:59  naderp
  Changed Proxy containment from channel to admin objects.
  Added Support for multiple admin objects per channel.

  Revision 1.1  1999/11/02 15:37:39  naderp
  *** empty log message ***

 * Revision 1.0  99/11/01  16:48:16  16:48:16  naderp (Paul Nader)
 * Initial revision
 * 
*/

#ifndef __OEP_TYPES_H_
#define __OEP_TYPES_H_

#include <list>
#ifdef _MSC_VER
using namespace std;
#endif
#include <Naming.hh>
#include <omniORB2/omniORB.h>

//------------------------------------------------------------------------
// Proxy Persistent Data Representation
//------------------------------------------------------------------------

class OEP_prxy
{
public:
  OEP_prxy();
  virtual ~OEP_prxy();

public:
  void setIor(char *ior);
  const char *getIor(void) const;
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;

private:
  omniORB::objectKey *key;
  char *ior;
};

//------------------------------------------------------------------------
// Consumer Admin Persistent Data Representation
//------------------------------------------------------------------------

class OEP_caps
{
public:
  OEP_caps();
  virtual ~OEP_caps();

public:
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;
  void addProxyPushSupplier(OEP_prxy *);
  const list<OEP_prxy *> &getProxyPushSuppliers(void) const;
  void addProxyPullSupplier(OEP_prxy *);
  const list<OEP_prxy *> &getProxyPullSuppliers(void) const;

private:
  list<OEP_prxy *> ppss;
  list<OEP_prxy *> ppls;
  omniORB::objectKey *key;
};

//------------------------------------------------------------------------
// Supplier Admin Persistent Data Representation
//------------------------------------------------------------------------

class OEP_saps
{
public:
  OEP_saps();
  virtual ~OEP_saps();

public:
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;
  void addProxyPushConsumer(OEP_prxy *);
  const list<OEP_prxy *> &getProxyPushConsumers(void) const;
  void addProxyPullConsumer(OEP_prxy *);
  const list<OEP_prxy *> &getProxyPullConsumers(void) const;

private:
  list<OEP_prxy *> ppsc;
  list<OEP_prxy *> pplc;
  omniORB::objectKey *key;
};

//------------------------------------------------------------------------
// Event Channel Persistent Data Representation
//------------------------------------------------------------------------
class OEP_ecps
{
public:
  OEP_ecps();
  virtual ~OEP_ecps();

public:
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;
  void addConsumerAdmin(OEP_caps *cadm);
  const list<OEP_caps *> &getConsumerAdmins(void) const;
  void addSupplierAdmin(OEP_saps *cadm);
  const list<OEP_saps *> &getSupplierAdmins(void) const;
  void setPullRetryPeriod(long);
  long getPullRetryPeriod(void) const;
  void setMaxEventsPerConsumer(long);
  long getMaxEventsPerConsumer(void) const;

private:
  omniORB::objectKey *key;
  list<OEP_caps *> cadm;
  list<OEP_saps *> sadm;
  long pullRetryPeriod;
  long maxEventsPerConsumer;
};

//------------------------------------------------------------------------
// Channel Factory Persistent Data Representation
//------------------------------------------------------------------------
class OEP_cfps
{
public:
  OEP_cfps();
  virtual ~OEP_cfps();

public:
  void setPort(unsigned int port);
  const unsigned int getPort(void) const;
  void setKey(omniORB::objectKey *key);
  const omniORB::objectKey *getKey(void) const;
  void addChannel(OEP_ecps *channel);
  list<OEP_ecps *> &getChannels(void);

private:
  unsigned int port;
  omniORB::objectKey *key;
  list<OEP_ecps *> channels;
};

#endif /* __OEP_TYPES_H_ */

