// -*- Mode: C++; -*-
//                            Package   : omniEvents
// oep_types.cc               Created   : 1/10/99
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//

/*
  $Log: oep_types.cc,v $
  Revision 1.3  2000/03/06 13:14:34  naderp
  Removed name and added port.

  Revision 1.2  2000/03/02 01:28:01  naderp
  Moved proxy containment from event channel to admin objects.

  Revision 1.1  1999/11/02 08:00:57  naderp
  Using defaults.h

Revision 1.0  99/11/01  16:29:28  16:29:28  naderp (Paul Nader)
Initial revision

*/

#include <defaults.h>
#include <oep_types.h>

//------------------------------------------------------------------------
// Proxy Persistent Data Representation
//------------------------------------------------------------------------

OEP_prxy::OEP_prxy() :
  key(NULL),
  ior(NULL)
{
  // Empty
}

OEP_prxy::~OEP_prxy()
{
  if (key != NULL)
  {
    delete key;
  }

  if (ior != NULL)
  {
    delete ior;
  }
}

void
OEP_prxy::setKey(omniORB::objectKey *k)
{
  if (key != NULL)
  {
    delete key;
  }

  key = k;
}

const omniORB::objectKey *
OEP_prxy::getKey(void) const
{
  return key;
}

void
OEP_prxy::setIor(char *i)
{
  if (ior != NULL)
  {
    delete ior;
  }

  ior = i;
}

const char *
OEP_prxy::getIor(void) const
{
  return ior;
}

//------------------------------------------------------------------------
// Consumer Admin Persistent Data Representation
//------------------------------------------------------------------------

OEP_caps::OEP_caps() :
  key(NULL)
{
  // Empty
}

OEP_caps::~OEP_caps()
{
  if (key != NULL)
  {
    delete key;
  }

  list<OEP_prxy *>::iterator iter;

  for (iter=ppss.begin(); iter != ppss.end(); iter++)
  {
    if (*iter != NULL)
    {
      delete *iter;
    }
  }

  for (iter=ppls.begin(); iter != ppls.end(); iter++)
  {
    if (*iter != NULL)
    {
      delete *iter;
    }
  }

}

void
OEP_caps::setKey(omniORB::objectKey *k)
{
  if (key != NULL)
  {
    delete key;
  }

  key = k;
}

const omniORB::objectKey *
OEP_caps::getKey(void) const
{
  return key;
}

void
OEP_caps::addProxyPushSupplier(OEP_prxy *p)
{
  ppss.push_front(p);
}

const list<OEP_prxy *> &
OEP_caps::getProxyPushSuppliers(void) const
{
  return ppss;
}

void
OEP_caps::addProxyPullSupplier(OEP_prxy *p)
{
  ppls.push_front(p);
}

const list<OEP_prxy *> &
OEP_caps::getProxyPullSuppliers(void) const
{
  return ppls;
}

//------------------------------------------------------------------------
// Supplier Admin Persistent Data Representation
//------------------------------------------------------------------------

OEP_saps::OEP_saps() :
  key(NULL)
{
  // Empty
}

OEP_saps::~OEP_saps()
{
  if (key != NULL)
  {
    delete key;
  }

  list<OEP_prxy *>::iterator iter;

  for (iter=ppsc.begin(); iter != ppsc.end(); iter++)
  {
    if (*iter != NULL)
    {
      delete *iter;
    }
  }

  for (iter=pplc.begin(); iter != pplc.end(); iter++)
  {
    if (*iter != NULL)
    {
      delete *iter;
    }
  }
}

void
OEP_saps::setKey(omniORB::objectKey *k)
{
  if (key != NULL)
  {
    delete key;
  }

  key = k;
}

const omniORB::objectKey *
OEP_saps::getKey(void) const
{
  return key;
}

void
OEP_saps::addProxyPushConsumer(OEP_prxy *p)
{
  ppsc.push_front(p);
}

const list<OEP_prxy *> &
OEP_saps::getProxyPushConsumers(void) const
{
  return ppsc;
}

void
OEP_saps::addProxyPullConsumer(OEP_prxy *p)
{
  pplc.push_front(p);
}

const list<OEP_prxy *> &
OEP_saps::getProxyPullConsumers(void) const
{
  return pplc;
}

//------------------------------------------------------------------------
// Event Channel Persistent Data Representation
//------------------------------------------------------------------------


OEP_ecps::OEP_ecps() :
  key(NULL),
  cadm(NULL),
  sadm(NULL),
  pullRetryPeriod(PULL_RETRY_PERIOD),
  maxEventsPerConsumer(MAX_EVENTS_PER_CONSUMER)
{
  // Empty
}

OEP_ecps::~OEP_ecps()
{
  if (key != NULL)
  {
    delete key;
  }

  list<OEP_caps *>::iterator ci;

  for (ci=cadm.begin(); ci != cadm.end(); ci++)
  {
    if (*ci != NULL)
    {
      delete *ci;
    }
  }

  list<OEP_saps *>::iterator si;

  for (si=sadm.begin(); si != sadm.end(); si++)
  {
    if (*si != NULL)
    {
      delete *si;
    }
  }
}

void
OEP_ecps::setKey(omniORB::objectKey *k)
{
  if (key != NULL)
  {
    delete key;
  }

  key = k;
}

const omniORB::objectKey *
OEP_ecps::getKey(void) const
{
  return key;
}

void
OEP_ecps::addConsumerAdmin(OEP_caps *c)
{
  cadm.push_front(c);
}

const list<OEP_caps *> &
OEP_ecps::getConsumerAdmins(void) const
{
  return cadm;
}

void
OEP_ecps::addSupplierAdmin(OEP_saps *s)
{
  sadm.push_front(s);
}

const list<OEP_saps *> &
OEP_ecps::getSupplierAdmins(void) const
{
  return sadm;
}

void
OEP_ecps::setPullRetryPeriod(long p)
{
  pullRetryPeriod = p;
}

long
OEP_ecps::getPullRetryPeriod(void) const
{
  return pullRetryPeriod;
}

void
OEP_ecps::setMaxEventsPerConsumer(long m)
{
  maxEventsPerConsumer = m;
}

long
OEP_ecps::getMaxEventsPerConsumer(void) const
{
  return maxEventsPerConsumer;
}



//------------------------------------------------------------------------
// Channel Factory Persistent Data Representation
//------------------------------------------------------------------------

OEP_cfps::OEP_cfps() :
  port(0),
  key(NULL)
{
  // Empty
}

OEP_cfps::~OEP_cfps()
{
  if (key != NULL)
  {
    delete key;
  }

  list<OEP_ecps *>::iterator iter;

  for (iter=channels.begin(); iter != channels.end(); iter++)
  {
    if (*iter != NULL)
    {
      delete *iter;
    }
  }
}

void
OEP_cfps::setPort(unsigned int p)
{
  port = p;
}

const unsigned int
OEP_cfps::getPort(void) const
{
  return port;
}

void
OEP_cfps::setKey(omniORB::objectKey *k)
{
  if (key != NULL)
  {
    delete key;
  }

  key = k;
}

const omniORB::objectKey *
OEP_cfps::getKey(void) const
{
  return key;
}

void
OEP_cfps::addChannel(OEP_ecps *channel)
{
  channels.push_front(channel);
}

list<OEP_ecps *> &
OEP_cfps::getChannels(void)
{
  return channels;
}
