// -*- Mode: C++; -*-
//                            Package   : omniEvents
// getopt.cc                  Created   : 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//
//    getopt implementation for WIN32 platforms.
//

/*
  $Log:	getopt.cc,v $
Revision 1.3  99/11/01  16:59:38  16:59:38  naderp (Paul Nader)
*** empty log message ***

Revision 1.2  99/04/23  12:11:18  12:11:18  naderp (Paul Nader)
*** empty log message ***

Revision 1.1  99/04/23  09:33:35  09:33:35  naderp (Paul Nader)
Initial revision
*/

#include <getopt.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>

// Zeitfunktionen beachten die Umgebungsvariable TZ
#include <time.h> /* _tzset() */
#if defined (__BORLANDC__)
#include <dos.h>
#define  _tzset()         tzset()
#endif

 
static  char   *letP = NULL;    // Speichert den Ort des Zeichens der
                                // naechsten Option
static  char    SW = 0;         // DOS-Schalter, entweder '-' oder '/'

// -------------------------------------------------------------- exports ----

int   optind  = 1;    // Index: welches Argument ist das naechste
char* optarg;         // Zeiger auf das Argument der akt. Option
int   opterr  = 1;    // erlaubt Fehlermeldungen

// ===========================================================================
int getopt(int argc, char *argv[], const char *optionS)
// ---------------------------------------------------------------------------
{
   unsigned char ch;
   char *optP;
    
   _tzset(); /* Zeitfunktionen beachten die Umgebungsvariable TZ */
    
   if (SW == 0)
   	SW = '-';
 
   if (argc > optind)
   {
      if (letP == NULL)
      {
         if ((letP = argv[optind]) == NULL || *(letP++) != SW)
            goto gopEOF;
         if (*letP == SW)
         {
            optind++;  goto gopEOF;
         }
      }
      if (0 == (ch = *(letP++)))
      {
         optind++;  goto gopEOF;
      }
      if (':' == ch  ||  (optP = (char*)strchr(optionS, ch)) == NULL)  
         goto gopError;
      if (':' == *(++optP))
      {
         optind++;
         if (0 == *letP)
         {
            if (argc <= optind)  goto  gopError;
               letP = argv[optind++];
         }
         optarg = letP;
         letP = NULL;
      } else
      {
         if (0 == *letP) {
            optind++;
            letP = NULL;
         }
         optarg = NULL;
      }
      return ch;
   }
gopEOF:
   optarg = letP = NULL;  
   return EOF;
    
gopError:
   optarg = NULL;
   errno  = EINVAL;
   if (opterr)
      perror ("error in command line");
   return ('?');
}
// ===========================================================================

//                      Ende von getopt ()
// ===========================================================================



