#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

EXPORT_TREE	= ..

CXXSRCS		= args.cc naming.cc
LIBOBJS		= args.o naming.o

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

CXXSRCS		+= getopt.cc
LIBOBJS		+= getopt.o
DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS)

else

DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES

endif

#############################################################################
#   Make variables for AIX                                                  #
#############################################################################

ifdef AIX

STL_INCLUDES	= /vob/tips/include/STL
DIR_CPPFLAGS	+= -I$(STL_INCLUDES)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

lib = $(patsubst %,$(LibPattern),omniEventsUtil)

all:: $(lib)

clean::
	$(RM) $(LIBOBJS) $(lib) *.d

$(lib): $(LIBOBJS)
	@$(StaticLinkLibrary)

export:: $(lib)
	@$(ExportLibrary)
