#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

EXPORT_TREE	= ..

CXXSRCS		= omniEvents.cc \
 		  CosEvent_i.cc \
		  omniEventsLog.cc \
		  EventChannelFactory_i.cc


LIBOBJS		= CosEvent_i.o \
		  omniEventsLog.o \
		  EventChannelFactory_i.o

OMNIEVENTSOBJS	= omniEvents.o

AUXLIBS		= ../$(LIBDIR)/$(patsubst %,$(LibPattern),omniEventsStubs) \
		  ../$(LIBDIR)/$(patsubst %,$(LibPattern),omniEventsFe) \
		  ../$(LIBDIR)/$(patsubst %,$(LibPattern),omniEventsUtil)

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

ifdef OMNIEVENTS_LOG_DEFAULT_LOCATION
DEFAULT_LOGDIR = $(OMNIEVENTS_LOG_DEFAULT_LOCATION)
else
DEFAULT_LOGDIR = C:\\TEMP
endif

DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS)
DIR_CPPFLAGS	+= -DDEFAULT_LOGDIR='"$(DEFAULT_LOGDIR)"'

else

#############################################################################
#   Make variables for Unix platforms                                       #
#############################################################################

ifdef OMNIEVENTS_LOG_DEFAULT_LOCATION
DEFAULT_LOGDIR = $(OMNIEVENTS_LOG_DEFAULT_LOCATION)
else
DEFAULT_LOGDIR = /var/omniEvents
endif

DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES
DIR_CPPFLAGS	+= -DDEFAULT_LOGDIR='"$(DEFAULT_LOGDIR)"'

endif

#############################################################################
#   Make variables for AIX                                                  #
#############################################################################

ifdef AIX

STL_INCLUDES	= /vob/tips/include/STL
DIR_CPPFLAGS	+= -I$(STL_INCLUDES)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

omniEvents	= $(patsubst %,$(BinPattern),omniEvents)
lib		= $(patsubst %,$(LibPattern),omniEvents)
EXECS		= $(omniEvents)

all:: $(lib) $(EXECS)

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(omniEvents)
	@$(ExportExecutable)

export:: $(lib)
	@$(ExportLibrary)

$(lib): $(LIBOBJS)
	@$(StaticLinkLibrary)

$(omniEvents): $(OMNIEVENTSOBJS) $(lib) $(AUXLIBS)
	@(libs="$(lib) $(AUXLIBS) $(CORBA_LIB)"; $(CXXExecutable))
