// -*- Mode: C++; -*-
//                            Package   : omniEvents
// omniEventsLog.h            Created   : 1/10/99
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//

/*
  $Log:	omniEventsLog.h,v $
 * Revision 1.1  99/11/02  13:40:56  13:40:56  naderp (Paul Nader)
 * Rearranged data member definitions to avoid compiler warnings during
 * initialisation.
 * 
  Revision 1.0  1999/11/01 16:48:21  naderp
  Initial revision

*/

#ifndef _OMNIEVENTSLOG_H_
#define _OMNIEVENTSLOG_H_

#include <omniORB2/CORBA.h>
#include <omniEvents.h>

class EventChannelFactory_i;

#ifndef LOGDIR_ENV_VAR
#define LOGDIR_ENV_VAR "OMNIEVENTS_LOGDIR"
#endif

class omniEventsLog {

public:
   omniEventsLog(int port, char* logdir=NULL);
   void init(CORBA::ORB_ptr, CORBA::BOA_ptr, EventChannelFactory_i *);
   int getPort();
   void checkpoint(void);
   friend ostream& operator<<(ostream &, const omniEventsLog &);
   static void persist();

public:
  static CORBA::ORB_ptr orb;
  static CORBA::BOA_ptr boa;
  class IOError {};

private:
  int port;
  char *logdir;
  ofstream logfile;
  int firstTime;
  char *active;				// Active file
  char *backup;				// Backup file
  char *checkpt;			// Checkpoint file
  omni_thread *recorder;                // In charge of checkpoints.
  OEP_GlobalData *oep_global;		// Parser global data
  EventChannelFactory_i *factory;
  int checkpointNeeded;
  static omniEventsLog *theLog;
  omni_mutex _lock;
};

class omniEventsLogWorker : public omni_thread {

public:
    typedef void (omniEventsLog::*Method)(void);
    omniEventsLogWorker(omniEventsLog *object,
                        Method method,
                        priority_t priority = PRIORITY_NORMAL);
    void* run_undetached(void *);
    ~omniEventsLogWorker();

private:
    omniEventsLog* _object;
    Method _method;
    omniEventsLogWorker();
};



#endif /* _OMNIEVENTSLOG_H_ */

