// -*- Mode: C++; -*-
//                            Package   : omniEvents
// CosEvent_i.h               Created   : 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//	

/*
  $Log:	EventChannelFactory_i.h,v $
 * Revision 1.1  99/11/02  13:40:53  13:40:53  naderp (Paul Nader)
 * Rearranged data member definitions to avoid compiler warnings during
 * initialisation.
 * 
  Revision 1.0  1999/11/01 16:41:59  naderp
  omniEvents R2.0.
  Added Persistency.
  Added MaxEventsPerConsumer criteria to factory.

 * Revision 0.1  99/08/27  11:50:43  11:50:43  naderp (Paul Nader)
 * Partitioned EventChannelFactory_i from CosEvent_i.
 * 
*/

#ifndef _EVENTCHANNELFACTORY_I_H_
#define _EVENTCHANNELFACTORY_I_H_

#include <omniEvents.h>
#include <EventChannelAdmin.hh>
#include <set>
#include <list>
#ifdef _MSC_VER
using namespace std;
#endif
#ifdef __linux__
#include <signal.h>
#endif

class EventChannel_i;

//
// EVENT CHANNEL FACTORY
//
// The following definitions are platform specific based on whether the STL implementation
// and compiler support default template arguments.

#if (defined (__GNUC__) && (__GNUC_MINOR__ < 8)) || \
    defined (__aix__) || \
    defined (__alpha__) || \
    defined (__sunos__)

typedef set<EventChannel_i *,less<EventChannel_i *> > EventChannelSet;

#elif (defined (__GNUC__) && (__GNUC_MINOR__ >= 8)) || \
      defined (__hpux__) || \
      defined (__WIN32__) || \
      defined (__irix__)

typedef set<EventChannel_i *> EventChannelSet;
#else

// Note: omniEvents has not been ported to your architecture. Please insert the appropiate
// symbols from your platform makefile above and try again. I'd appreciate any changes made
// to get it to work on a new platform be reported to Paul.Nader@alcatel.com.au. Cheers.

#endif

// Event Channel Factory

class EventChannelFactory_i :
  public EventChannelAdmin::_sk_EventChannelFactory {

public:
   EventChannelFactory_i ();
   EventChannelFactory_i(const omniObjectKey &,const CosNaming::Name &);
   EventChannelFactory_i(const omniObjectKey &,const CosNaming::Name &,list<OEP_ecps *> &);
   CORBA::Boolean supports (const CosLifeCycle::Key &k);
   CORBA::Object_ptr create_object(const CosLifeCycle::Key &k,
                                   const CosLifeCycle::Criteria &the_criteria);
   friend std::ostream& operator<<(std::ostream &, const EventChannelFactory_i &);

private:
   CosNaming::Name name;
   omniORB::objectKey key;
   EventChannelSet eventChannels;
};

#endif /* _EVENTCHANNELFACTORY_I_H_ */
