#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

EXPORT_TREE	= ..

LIBOBJS		= $(CORBA_STUB_OBJS)

CORBA_INTERFACES = Naming \
		   CosLifeCycle \
                   CosEventComm \
                   CosEventChannelAdmin \
                   EventChannelAdmin


#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

DIR_CPPFLAGS += $(CORBA_CPPFLAGS)

else

DIR_CPPFLAGS += $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES

endif

#############################################################################
#   Make variables for AIX                                                  #
#############################################################################

ifdef AIX

STL_INCLUDES = /vob/tips/include/STL
DIR_CPPFLAGS += -I$(STL_INCLUDES)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

lib = $(patsubst %,$(LibPattern),omniEventsStubs)

all:: $(lib)

clean::
	$(RM) $(lib) *.d

$(lib): $(LIBOBJS)
	@$(StaticLinkLibrary)

export:: $(lib)
	@$(ExportLibrary)
