/*
//                            Package   : omniEvents
// oep.yy                     Created   : 27/9/99
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//
//    omniEvents persistency parser.
//
*/

/*
  $Log:	oep.yy,v $
Revision 1.0  99/11/01  16:29:22  16:29:22  naderp (Paul Nader)
Initial revision

*/


/* Declarations */

%{
#include <omniEvents.h>

#ifdef __cplusplus
#ifndef __EXTERN_C__
#define __EXTERN_C__
#endif
extern	"C" int yywrap();
extern  "C" void yyerror(const char*);
#endif

extern int yylex();
extern char* yytext;

#ifndef alloca
#define alloca malloc
#endif

#define YYDEBUG 1
%}

/*
 * Declare the type of values in the grammar
 */

%union {
  long			ival;		/* Long value			*/
  double		dval;		/* Double value			*/
  float			fval;		/* Float value			*/
  char			cval;		/* Char value			*/
  char			*sval;		/* string value			*/
  omniORB::objectKey	*kval;		/* key value			*/
  CosNaming::Name	*nval;		/* name value			*/
  OEP_cfps		*cfps;		/* Channel Factory params	*/
  OEP_ecps		*ecps;		/* Event Channel params		*/
  OEP_caps		*caps;		/* Consumer Admin params	*/
  OEP_saps		*saps;		/* Supplier Admin params	*/
  OEP_prxy		*prxy;		/* Proxy params			*/
}

/*
 * Token types: These are returned by the lexer
 */

%token		COMMON_LABEL
%token		CHANNELFACTORY_LABEL
%token		EVENTCHANNEL_LABEL
%token		CONSUMERADMIN_LABEL
%token		SUPPLIERADMIN_LABEL
%token		PROXYPUSHSUPP_LABEL
%token		PROXYPUSHCONS_LABEL
%token		PROXYPULLSUPP_LABEL
%token		PROXYPULLCONS_LABEL
%token 		NAME_LABEL
%token 		IOR_LABEL
%token 		KEY_LABEL
%token 		PORT_LABEL
%token		PULLRETRYPERIOD_LABEL
%token		MAXEVENTSPERCONSUMER_LABEL


%token <sval>	IOR_VALUE
%token <kval>	KEY_VALUE
%token <ival>	INTEGER_LITERAL
%token <sval>	STRING_LITERAL
%token		TRUETOK
%token		FALSETOK


/*
 * These are production names:
 */
%type <ival>	port
%type <sval>	ior
%type <kval>	key
%type <nval>	name
%type <kval>	key_value
%type <nval>	name_value
%type <sval>	ior_value
%type <ival>	integer_literal
%type <sval>	string_literal
%type <ival>	common
%type <cfps>	channelFactoryParams
%type <cfps>	channelFactory
%type <ecps>	eventChannelParams
%type <ecps>	eventChannel
%type <caps>	consumerAdmin
%type <caps>	consumerAdminParams
%type <saps>	supplierAdmin
%type <saps>	supplierAdminParams
%type <prxy>	proxyPushCons
%type <prxy>	proxyPushConsParams
%type <prxy>	proxyPushSupp
%type <prxy>	proxyPushSuppParams
%type <prxy>	proxyPullCons
%type <prxy>	proxyPullConsParams
%type <prxy>	proxyPullSupp
%type <prxy>	proxyPullSuppParams
%type <ival>	pullRetryPeriod
%type <ival>	maxEventsPerConsumer

%%

/*
 * Production starts here
 */

start : 
	common channelFactory
	{
	  oep_global->setPortNo($1);
	  oep_global->setFactory($2);
	}
        | start common channelFactory
        {
	  oep_global->setPortNo($2);
	  oep_global->setFactory($3);
        }
	;

common :
	COMMON_LABEL
	'{'
	port
	'}'
	{
	  $$ = $3;
	}
	;

channelFactory :
	CHANNELFACTORY_LABEL
	'{'
	channelFactoryParams
	'}'
	{
	  /* check mandatory parameters */
	  if (($3->getKey() == NULL) ||
	      ($3->getName() == NULL))
	  {
	    yyerror("missing mandatory parameter");
	    YYABORT;
	  }
	  $$ = $3;
	}
	;

channelFactoryParams :
	channelFactoryParams key
	{
	   if ($$->getKey())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setKey($2);
	}
	| channelFactoryParams name
	{
	   if ($$->getName())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setName($2);
	}
	| channelFactoryParams eventChannel
	{
	   $$->addChannel($2);
	}
	| /* empty */
	{
	   /* allocate and initialise */
	   $$ = new OEP_cfps();
	}
	;

eventChannel :
	EVENTCHANNEL_LABEL
	'{'
	eventChannelParams
	'}'
	{
	  /* check mandatory parameters */
	  if (($3->getKey() == NULL) ||
	      ($3->getSupplierAdmin() == NULL) ||
	      ($3->getConsumerAdmin() == NULL))
	  {
	    yyerror("missing mandatory parameter");
	    YYABORT;
	  }
	  $$ = $3;
	}
	;

eventChannelParams :
	eventChannelParams key
	{
	   if ($$->getKey())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setKey($2);
	}
	| eventChannelParams pullRetryPeriod
	{
	   $$->setPullRetryPeriod($2);
	}
	| eventChannelParams maxEventsPerConsumer
	{
	   $$->setMaxEventsPerConsumer($2);
	}
	| eventChannelParams supplierAdmin
	{
	   if ($$->getSupplierAdmin())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setSupplierAdmin($2);
	}
	| eventChannelParams consumerAdmin
	{
	   if ($$->getConsumerAdmin())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setConsumerAdmin($2);
	}
	| eventChannelParams proxyPushCons
	{
	   $$->addProxyPushConsumer($2);
	}
	| eventChannelParams proxyPushSupp
	{
	   $$->addProxyPushSupplier($2);
	}
	| eventChannelParams proxyPullCons
	{
	   $$->addProxyPullConsumer($2);
	}
	| eventChannelParams proxyPullSupp
	{
	   $$->addProxyPullSupplier($2);
	}
	| /* empty */
	{
	   /* allocate and initialise */
	   $$ = new OEP_ecps;
	}
	;

consumerAdmin :
	CONSUMERADMIN_LABEL
	'{'
	consumerAdminParams
	'}'
	{
	  /* check mandatory parameters */
	  if ($3->getKey() == NULL)
	  {
	    yyerror("missing mandatory parameter");
	    YYABORT;
	  }
	  $$ = $3;
	}
	;

consumerAdminParams :
	consumerAdminParams key
	{
	   if ($$->getKey())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setKey($2);
	}
	| /* empty */
	{
	   /* allocate and initialise */
	   $$ = new OEP_caps;
	}
	;

supplierAdmin :
	SUPPLIERADMIN_LABEL
	'{'
	supplierAdminParams
	'}'
	{
	  /* check mandatory parameters */
	  if ($3->getKey() == NULL)
	  {
	    yyerror("missing mandatory parameter");
	    YYABORT;
	  }
	  $$ = $3;
	}
	;

supplierAdminParams :
	supplierAdminParams key
	{
	   if ($$->getKey())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setKey($2);
	}
	| /* empty */
	{
	   /* allocate and initialise */
	   $$ = new OEP_saps;
	}
	;

proxyPushCons :
	PROXYPUSHCONS_LABEL
	'{'
	proxyPushConsParams
	'}'
	{
	  /* check mandatory parameters */
	  if ($3->getKey() == NULL)
	  {
	    yyerror("missing mandatory parameter");
	    YYABORT;
	  }
	  $$ = $3;
	}
	;

proxyPushConsParams :
	proxyPushConsParams key
	{
	   if ($$->getKey())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setKey($2);
	}
	| proxyPushConsParams ior
	{
	   if ($$->getIor())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setIor($2);
	}
	| /* empty */
	{
	   /* allocate and initialise */
	   $$ = new OEP_prxy;
	}
	;

proxyPushSupp :
	PROXYPUSHSUPP_LABEL
	'{'
	proxyPushSuppParams
	'}'
	{
	  /* check mandatory parameters */
	  if ($3->getKey() == NULL)
	  {
	    yyerror("missing mandatory parameter");
	    YYABORT;
	  }
	  $$ = $3;
	}
	;

proxyPushSuppParams :
	proxyPushSuppParams key
	{
	   if ($$->getKey())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setKey($2);
	}
	| proxyPushSuppParams ior
	{
	   if ($$->getIor())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setIor($2);
	}
	| /* empty */
	{
	   /* allocate and initialise */
	   $$ = new OEP_prxy;
	}
	;

proxyPullCons :
	PROXYPULLCONS_LABEL
	'{'
	proxyPullConsParams
	'}'
	{
	  /* check mandatory parameters */
	  if ($3->getKey() == NULL)
	  {
	    yyerror("missing mandatory parameter");
	    YYABORT;
	  }
	  $$ = $3;
	}
	;

proxyPullConsParams :
	proxyPullConsParams key
	{
	   if ($$->getKey())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setKey($2);
	}
	| proxyPullConsParams ior
	{
	   if ($$->getIor())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setIor($2);
	}
	| /* empty */
	{
	   /* allocate and initialise */
	   $$ = new OEP_prxy;
	}
	;

proxyPullSupp :
	PROXYPULLSUPP_LABEL
	'{'
	proxyPullSuppParams
	'}'
	{
	  /* check mandatory parameters */
	  if ($3->getKey() == NULL)
	  {
	    yyerror("missing mandatory parameter");
	    YYABORT;
	  }
	  $$ = $3;
	}
	;

proxyPullSuppParams :
	proxyPullSuppParams key
	{
	   if ($$->getKey())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setKey($2);
	}
	| proxyPullSuppParams ior
	{
	   if ($$->getIor())
	   {
	      yyerror("duplicate parameter");
	      YYABORT;
	   }
	   $$->setIor($2);
	}
	| /* empty */
	{
	   /* allocate and initialise */
	   $$ = new OEP_prxy;
	}
	;

pullRetryPeriod :
	PULLRETRYPERIOD_LABEL integer_literal
	{
	   $$ = $2;
	}
	;

maxEventsPerConsumer :
	MAXEVENTSPERCONSUMER_LABEL integer_literal
	{
	   $$ = $2;
	}
	;

port :
	PORT_LABEL integer_literal
	{
	   $$ = $2;
	}
	;

ior :
	IOR_LABEL ior_value
	{
	   $$ = $2;
	}
	;

key :
	KEY_LABEL key_value
	{
	   $$ = $2;
	}
	;

name :
	NAME_LABEL name_value
	{
	   $$ = $2;
	}
	;

name_value :
	name_value string_literal '/' string_literal
	{
	   if ($1 == NULL)
	   {
	     $$ = new CosNaming::Name(1);
	     $$->length(1);

	     // assign components
	     (*$$)[0].id = CORBA::string_dup($2);
	     (*$$)[0].kind = CORBA::string_dup($4);
	   }
	   else
	   {
	     // Copy previous value
	     $$ = new CosNaming::Name(*$1);

	     // grow sequence
	     long l = $1->length();
	     $$->length(l + 1);
	     delete $1;

	     // assign components
	     (*$$)[l].id = CORBA::string_dup($2);
	     (*$$)[l].kind = CORBA::string_dup($4);
	   }
	}
	| /* empty */
	{
	  $$ = NULL;
	}
	;

ior_value :
	IOR_VALUE
	{
	   $$ = $1;
	}
	;

key_value :
	KEY_VALUE
	{
	   $$ = $1;
	}
	;

integer_literal :
	INTEGER_LITERAL
	{
	   $$ = $1;
	}
	;

string_literal :
	STRING_LITERAL
	{
	   $$ = $1;
	}
	;
	
%%
/* programs */

/*
 * ???
 */
int
yywrap()
{
  return 1;
}

/*
 * Report an error situation discovered in a production
 */
void
yyerror(const char * text)
{
   cerr << text << " at line "
        << ((OEP_GlobalData *) oep_global)->getLineNo() + 1
        << endl;
}
