#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

EXPORT_TREE     = ..

CHKFMTOBJS	= chkfmt.o

CXXSRCS		= y.tab.cc \
		  lex.yy.cc \
		  oep_types.cc \
		  oep_global.cc \
		  chkfmt.cc

LIBOBJS		= y.tab.o \
		  lex.yy.o \
		  oep_types.o \
		  oep_global.o

AUXLIBS		= ../$(LIBDIR)/$(patsubst %,$(LibPattern),omniEventsFe) \
		  ../$(LIBDIR)/$(patsubst %,$(LibPattern),omniEventsUtil)

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS)

else

#############################################################################
#   Make variables for Unix platforms                                       #
#############################################################################

DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES

endif

#############################################################################
#   Make variables for AIX                                                  #
#############################################################################

ifdef AIX

STL_INCLUDES = /vob/tips/include/STL
DIR_CPPFLAGS += -I$(STL_INCLUDES)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

lib		= $(patsubst %,$(LibPattern),omniEventsFe)
chkfmt		= $(patsubst %,$(BinPattern),chkfmt)

EXECS		= $(chkfmt)

all:: $(lib) $(EXECS)

clean::
	$(RM) $(lib) $(EXECS) *.d *.o

$(lib): $(LIBOBJS)
	@$(StaticLinkLibrary)

export:: $(lib)
	@$(ExportLibrary)

$(chkfmt): $(CHKFMTOBJS) $(lib)
	@(libs="$(AUXLIBS) $(CORBA_LIB)"; $(CXXExecutable))

export:: $(chkfmt)
	@$(ExportExecutable)

#
# Create the parser and lexer
#
# If ever we need to regenerate lex.yy.cc and y.tab.cc, use bison and flex
#
#lex.yy.cc: oep.ll
#	@-$(RM) $@
#	flex -B $<
#	sed -e 's/^#include <unistd.h>//' lex.yy.c > $@
#	rm -f lex.yy.c
#	echo '#ifdef __VMS' >> $@
#	echo '// Some versions of DEC C++ for OpenVMS set the module name used by the'>>$@
#	echo '// librarian based on the last #line encountered.' >> $@
#	echo '#line' `cat $@ | wc -l` '"lex_yy.cc"' >> $@
#	echo '#endif' >> $@
#
#y.tab.cc: oep.yy
#	@-$(RM) $@
#	bison -d -y $<
#	mv -f y.tab.c y.tab.cc
#	echo '#ifdef __VMS' >> $@
#	echo '// Some versions of DEC C++ for OpenVMS set the module name used by the'>>$@
#	echo '// librarian based on the last #line encountered.' >> $@
#	echo '#line' `cat $@ | wc -l` '"y_tab.cc"' >> $@
#	echo '#endif' >> $@
#
