// -*- Mode: C++; -*-
//                            Package   : omniEvents
// chkfmt.cc                  Created   : 1/10/99
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    chkfmt standalone utility for parsing omniEvents log files.
//

/*
  $Log: chkfmt.cc,v $
  Revision 1.0  1999/11/01 16:29:10  naderp
  Initial revision

*/

#include <omniEvents.h>

#ifdef __WIN32__
#include <getopt.h>
#else
#include <unistd.h>
#endif

#include <args.h>

extern int yyparse();
extern int yydebug;
extern FILE *yyin;
OEP_GlobalData *oep_global;

static void usage();

int main(int argc, char **argv)
{
  //
  // Process Options
  int c;
  while ((c = getopt(argc,argv,"d")) != EOF)
  {
     switch (c)
     {
        case 'd': yydebug = 1;
                  removeArgs(argc, argv, 1, 1);
                  break;

        case 'h':
        default : usage();
                  exit(-1);
                  break;
     }
  }

  //
  // Last argument is optional filename
  if (argc > 1)
  {
     FILE *file = fopen(argv[1], "r");
     if (!file)
     {
        fprintf(stderr, "can't open %s\n", argv[1]);
        exit(-1);
     }
     yyin = file;
  }

  oep_global = new OEP_GlobalData();
  int result = yyparse();
  return result;
}

static void
usage()
{
   cerr << "\nusage: chkfmt [-d] [filename]" << endl;
}
