#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

EXPORT_TREE	= ..

CXXSRCS		= eventc.cc \
		  pushcons.cc \
		  pushsupp.cc \
		  pullsupp.cc \
		  pullcons.cc

EVENTCOBJS	= eventc.o
PUSHSUPPOBJS	= pushsupp.o
PUSHCONSOBJS	= pushcons.o
PULLCONSOBJS	= pullcons.o
PULLSUPPOBJS	= pullsupp.o

AUXLIBS		= ../$(LIBDIR)/$(patsubst %,$(LibPattern),omniEvents) \
		  ../$(LIBDIR)/$(patsubst %,$(LibPattern),omniEventsStubs) \
		  ../$(LIBDIR)/$(patsubst %,$(LibPattern),omniEventsUtil)


#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS)

else

#############################################################################
#   Make variables for Unix platforms                                       #
#############################################################################

DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES

endif

#############################################################################
#   Make variables for AIX                                                  #
#############################################################################

ifdef AIX

STL_INCLUDES	= /vob/tips/include/STL
DIR_CPPFLAGS	+= -I$(STL_INCLUDES)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

eventc    = $(patsubst %,$(BinPattern),eventc)
pushsupp  = $(patsubst %,$(BinPattern),pushsupp)
pushcons  = $(patsubst %,$(BinPattern),pushcons)
pullcons  = $(patsubst %,$(BinPattern),pullcons)
pullsupp  = $(patsubst %,$(BinPattern),pullsupp)


EXECS     = $(eventc) $(pushsupp) $(pushcons) $(pullcons) $(pullsupp)

all:: $(EXECS)

export:: $(EXECS)
	@$(ExportExecutable)

clean::
	$(RM) $(EXECS) *.d

$(eventc): $(EVENTCOBJS) $(AUXLIBS)
	@(libs="$(AUXLIBS) $(CORBA_LIB)"; $(CXXExecutable))

$(pushsupp): $(PUSHSUPPOBJS)
	@(libs="$(AUXLIBS) $(CORBA_LIB)"; $(CXXExecutable))

$(pushcons): $(PUSHCONSOBJS)
	@(libs="$(AUXLIBS) $(CORBA_LIB)"; $(CXXExecutable))

$(pullcons): $(PULLCONSOBJS)
	@(libs="$(AUXLIBS) $(CORBA_LIB)"; $(CXXExecutable))

$(pullsupp): $(PULLSUPPOBJS)
	@(libs="$(AUXLIBS) $(CORBA_LIB)"; $(CXXExecutable))
