// -*- Mode: C++; -*-
//                            Package   : omniEvents
//   pushsupp.cc              Created on: 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omnievents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//    Push Model supplier implementation.
//	

/*
  $Log:	pushsupp.cc,v $
Revision 0.4  99/04/23  16:05:47  16:05:47  naderp (Paul Nader)
gcc port.

Revision 0.3  99/04/23  09:34:04  09:34:04  naderp (Paul Nader)
Windows Port.

Revision 0.2  99/04/21  18:06:26  18:06:26  naderp (Paul Nader)
*** empty log message ***

Revision 0.1.1.1  98/11/27  16:59:40  16:59:40  naderp (Paul Nader)
Added -s option to sleep after disconnecting.

Revision 0.1  98/11/25  14:08:25  14:08:25  naderp (Paul Nader)
Initial Revision

*/

//
//
#include <iostream.h>
#include "CosEvent_i.h"
#ifdef __WIN32__
#include "getopt.h"
#else
#include <unistd.h>
#endif

static void usage();

class Supplier_i : virtual public CosEventComm::_sk_PushSupplier {
public:
  Supplier_i () {};
  void disconnect_push_supplier ();
};

void
Supplier_i::disconnect_push_supplier () {
  cout << "EventSupplier: disconnected." << endl;
}

int main (int argc, char** argv)
{
  long l = 0;
  CORBA::ORB_var orb = CORBA::ORB_init (argc, argv, "omniORB2");
  CORBA::BOA_var boa = orb->BOA_init (argc, argv, "omniORB2_BOA");

  // Process Options
  int c;
  int discnum = 0;
  int sleepInterval = 0;
  char *channelName = (char *) "EventChannel";
  char *channelKind = (char *) "EventChannel";
  while ((c = getopt(argc,argv,"d:s:n:k:h")) != EOF)
  {
     switch (c)
     {
        case 'd': discnum = atoi(optarg);
                  break;

        case 's': sleepInterval = atoi(optarg);
                  break;


        case 'n': channelName = optarg;
                  break;

        case 'k': channelKind = optarg;
                  break;

        case 'h':
        default : usage();
                  exit(-1);
                  break;
     }
  }

  Supplier_i* supplier = new Supplier_i ();
  supplier->_obj_is_ready(boa);

  CosNaming::NamingContext_var rootContext;
  try {

     // Get NameService reference
     CORBA::Object_var initServ;
     initServ = orb->resolve_initial_references ("NameService");
     if (CORBA::is_nil(initServ))
     {
        cerr << "Failed to obtain NameService reference !" << endl;
        exit(1);
     }

     // Narrow NameService reference
     rootContext = CosNaming::NamingContext::_narrow(initServ);
     if (CORBA::is_nil(rootContext))
     {
        cerr << "Failed to narrow naming context !" << endl;
        exit(1);
     }
  }
  catch(CORBA::ORB::InvalidName& ex) {
     cerr << "Naming Service is invalid [does not exist] !" << endl;
     exit(1);
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE, unable to contact the naming service."
          << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception !" << endl;
     throw;
  }
  catch (...) {
     cerr << "Caught a system exception while resolving the naming service !"
          << endl;
     exit(1);
  }

  // Obtain Event Channel Object.
  CosNaming::Name name;
  name.length (1);
  name[0].id = CORBA::string_dup (channelName);
  name[0].kind = CORBA::string_dup (channelKind);

  cout << "Looking for EventChannel" << endl;
  CosEventChannelAdmin::EventChannel_var event_channel;
  try {
    CORBA::Object_var obj = rootContext->resolve (name);
    event_channel = CosEventChannelAdmin::EventChannel::_narrow (obj);
    if (CORBA::is_nil (event_channel))
    {
       cerr << "Failed to narrow Event Channel !" << endl;
       exit(1);
    }
  }
  catch (CORBA::ORB::InvalidName& ex) {
     cerr << "Service required is invalid [does not exist]. !" << endl;
     exit(1);
  }
  catch (CORBA::COMM_FAILURE& ex) {
     cerr << "Caught system exception COMM_FAILURE, unable to contact the naming service !"
          << endl;
     exit(1);
  }
  catch (omniORB::fatalException& ex) {
     cerr << "Caught Fatal Exception !" << endl;
     throw;
  }
  catch (...) {
     cerr << "Cannot find event channel ! [\""
          << channelName << "\", \"" << channelKind << "\"]"
          << endl;
     exit(1);
  }

  CosEventChannelAdmin::SupplierAdmin_var supplier_admin;
  try {
     supplier_admin = event_channel->for_suppliers ();
     if (CORBA::is_nil(supplier_admin))
     {
        cerr << "Failed to find Supplier Admin !" << endl;
        exit(1);
     }
  }
  catch (...) {
     cerr << "Failed to obtain Supplier Admin !"
          << endl;
  }
  cerr << "Obtained SupplierAdmin." << endl;

  CosEventChannelAdmin::ProxyPushConsumer_var proxy_consumer;
  while (1)
  {
     //
     // Get proxy consumer interface
     try {
        proxy_consumer = supplier_admin->obtain_push_consumer ();
        if (CORBA::is_nil(proxy_consumer))
        {
           cerr << "Failed to find Proxy Consumer !" << endl;
           exit(1);
        }
     }
     catch (...) {
        cerr << "Failed to obtain Proxy Consumer !" << endl;
        exit(1);
     }
     cerr << "Obtained ProxyPushConsumer." << endl;
   
     // Connect Push Supplier
      try {
        proxy_consumer->connect_push_supplier(CosEventComm::PushSupplier::_duplicate(supplier));
     }
     catch (CORBA::BAD_PARAM& ex) {
        cerr << "Caught BAD_PARAM Exception while connecting Push Supplier !"
             << endl;
        exit (1);
     }
     catch (CosEventChannelAdmin::AlreadyConnected& ex) {
        cerr << "Pull Supplier already connected !"
             << endl;
     }
     catch (...) {
        cerr << "Failed to connect Push Supplier !" << endl;
        exit (1);
     }
     cerr << "Connected Push Supplier." << endl;
   
     // Let the BOA know we are ready, without blocking...
     boa->impl_is_ready(0,1);
   
     // Push data.
     for (int i=0; (discnum == 0) || (i < discnum); i++)
     {
        CORBA::Any any;
        any <<= (CORBA::ULong) l++;
        try {
           cout << "Push Supplier: push() called. ";
           proxy_consumer->push(any);
           cout << "Data : " << l-1 << endl;
        }
        catch (...) {
           cout << "Failed !" << endl;
        }
     }
   
     // Disconnect
     try {
        proxy_consumer->disconnect_push_consumer();
     }
     catch (...) {
        cerr << "Failed to disconnect ProxyPushConsumer !" << endl;
        exit(1);
     }
     cerr << "ProxyPushConsumer disconnected." << endl;

     // Yawn.
     omni_thread::sleep(sleepInterval);
     cerr << "Sleeping " << sleepInterval << " Seconds." << endl;
  }

  // Not Reached
  return 0;
}

static void
usage()
{
   cerr << "\nusage: pushsupp [-d n [-s n]] [-h]\n" << endl;
   cerr << "         -d n   disconnect after n pushes" << endl;
   cerr << "         -s n   sleep n seconds after disconnecting" << endl;
   cerr << "         -n name specify channel name [\"EventChannel\"]" << endl;
   cerr << "         -k kind specify channel kind [\"EventChannel\"]" << endl;
   cerr << "         -h     display usage" << endl;
   cerr << endl;
}
