#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

CXXSRCS = CosEvent_i.cc \
          eventc.cc \
          eventd.cc \
          pushcons.cc \
          pushsupp.cc \
          pullsupp.cc \
          pullcons.cc

AUXLIBS =
LIBOBJS = CosEvent_i.o
EVENTDOBJS = eventd.o
EVENTCOBJS = eventc.o
PUSHSUPPOBJS = pushsupp.o
PUSHCONSOBJS = pushcons.o
PULLCONSOBJS = pullcons.o
PULLSUPPOBJS = pullsupp.o

CORBA_INTERFACES = Naming \
                   CosLifeCycle \
                   CosEventComm \
                   CosEventChannelAdmin \
                   EventChannelAdmin

DIR_CPPFLAGS = $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

CXXSRCS += getopt.cc
EVENTDOBJS += getopt.o
EVENTCOBJS += getopt.o
PUSHSUPPOBJS += getopt.o
PUSHCONSOBJS += getopt.o
PULLCONSOBJS += getopt.o
PULLSUPPOBJS += getopt.o

endif

#############################################################################
#   Make variables for AIX                                                  #
#############################################################################

ifdef AIX

STL_INCLUDES = /vob/tips/include/STL
DIR_CPPFLAGS += -I$(STL_INCLUDES)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

eventd    = $(patsubst %,$(BinPattern),eventd)
eventc    = $(patsubst %,$(BinPattern),eventc)
pushsupp  = $(patsubst %,$(BinPattern),pushsupp)
pushcons  = $(patsubst %,$(BinPattern),pushcons)
pullcons  = $(patsubst %,$(BinPattern),pullcons)
pullsupp  = $(patsubst %,$(BinPattern),pullsupp)

lib = $(patsubst %,$(LibPattern),omniEvents)


EXECS     = $(eventd) $(eventc) $(pushsupp) $(pushcons) $(pullcons) $(pullsupp)

all:: $(lib) $(EXECS)

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(eventd)
	@(module="as"; $(ExportExecutable))

$(lib): $(LIBOBJS)
	@$(StaticLinkLibrary)

$(eventd): $(EVENTDOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(lib)
	@(libs="$(CORBA_LIB) $(lib) $(AUXLIBS)"; $(CXXExecutable))

$(eventc): $(EVENTCOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(lib)
	@(libs="$(CORBA_LIB) $(lib) $(AUXLIBS)"; $(CXXExecutable))

$(pushsupp): $(PUSHSUPPOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(lib)
	@(libs="$(CORBA_LIB) $(lib) $(AUXLIBS)"; $(CXXExecutable))

$(pushcons): $(PUSHCONSOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(lib)
	@(libs="$(CORBA_LIB) $(lib) $(AUXLIBS)"; $(CXXExecutable))

$(pullcons): $(PULLCONSOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(lib)
	@(libs="$(CORBA_LIB) $(lib) $(AUXLIBS)"; $(CXXExecutable))

$(pullsupp): $(PULLSUPPOBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(lib)
	@(libs="$(CORBA_LIB) $(lib) $(AUXLIBS)"; $(CXXExecutable))
