// -*- Mode: C++; -*-
//                            Package   : omniEvents
// CosEvent_i.h               Created   : 1/4/98
//                            Author    : Paul Nader (pwn)
//
//    Copyright (C) 1998 Paul Nader.
//
//    This file is part of the omniEvents application.
//
//    omniEvents is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This application is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//	

/*
  $Log:	CosEvent_i.h,v $
 * Revision 0.8  99/05/10  11:32:05  11:32:05  naderp (Paul Nader)
 * Preliminary SunOS Port.
 * 
 * Revision 0.7  99/05/10  11:28:35  11:28:35  naderp (Paul Nader)
 * Added signal.h for linux.
 * Corrected ProxyPullConsumerSet Declaration.
 * 
 * Revision 0.6  99/04/29  15:48:34  15:48:34  naderp (Paul Nader)
 * Added comparator for set container for architectures that don't
 * support default template arguments.
 * 
 * Revision 0.5  99/04/23  16:13:30  16:13:30  naderp (Paul Nader)
 * *** empty log message ***
 * 
 * Revision 0.4  99/04/23  10:45:44  10:45:44  naderp (Paul Nader)
 * Moved EventChannelAdmin to EventChannelAdmin.idl.
 * 
 * Revision 0.3  99/04/23  09:36:21  09:36:21  naderp (Paul Nader)
 * Windows Port.
 * 
 * Revision 0.2  99/04/21  18:13:38  18:13:38  naderp (Paul Nader)
 * *** empty log message ***
 * 
 * Revision 0.1.1.1  98/12/01  06:07:49  06:07:49  naderp (Paul Nader)
 * Adding Agent Mode Functionality.
 * 
 * Revision 0.1  98/11/25  14:05:34  14:05:34  naderp (Paul Nader)
 * Initial Revision
 * 
*/

#ifndef CosEvent_i_h_
#define CosEvent_i_h_

#include "CosEventComm.hh"
#include "CosEventChannelAdmin.hh"
#include "EventChannelAdmin.hh"
#include <list>
#include <set>
#ifdef _MSC_VER
using namespace std;
#endif
#ifdef __linux__
#include <signal.h>
#endif

class EventChannel_i;

class stamp_t {
public:
    stamp_t() {sec = 0; nsec = 0;};
    int operator<=(const stamp_t& lhs) const {return (sec <= lhs.sec);}; 
    void get_time (void) { omni_thread::get_time(&sec, &nsec, 0, 0);};

    int operator == (const stamp_t& s) const {
      return((sec == s.sec) && (nsec == s.nsec));
    }
 
    int operator != (const stamp_t& s) const {
      return((sec != s.sec) || (nsec != s.nsec));
    }
 
    int operator < (const stamp_t& s) const {
      return((sec < s.sec) || ((sec == s.sec) && (nsec < s.nsec)));
    }

    int operator > (const stamp_t& s) const {
      return((sec > s.sec) || ((sec == s.sec) && (nsec > s.nsec)));
    }

public:
    unsigned long sec;
    unsigned long nsec;
};


class event_t {
public:
    int operator == (const event_t& e) const {
      return(stamp == e.stamp);
    }

    int operator != (const event_t& e) const {
      return(stamp != e.stamp);
    }

    int operator < (const event_t& e) const {
      return(stamp < e.stamp);
    }

    int operator > (const event_t& e) const {
      return(stamp > e.stamp);
    }

public:
    CORBA::Any data;
    stamp_t stamp;
};

// PUSH
//------------------------------------------------------------------------
class ProxyPushConsumer_i;
typedef ProxyPushConsumer_i* ProxyPushConsumerImpl_ptr;

class ProxyPushConsumer_i :
  virtual public CosEventComm::_sk_PushConsumer,
  virtual public CosEventChannelAdmin::_sk_ProxyPushConsumer {
public:
    ProxyPushConsumer_i (EventChannel_i* impl);

    void connect_push_supplier (CosEventComm::PushSupplier_ptr push_supplier);
    void push (const CORBA::Any& data);
    void disconnect_push_consumer ();

private:
    omni_mutex      _lock;
    EventChannel_i* _channel;
    CosEventComm::PushSupplier_ptr _supplier;
    enum {notConnected, connected, disconnected} _proxyState;
};

//------------------------------------------------------------------------
class ProxyPushSupplier_i;
typedef ProxyPushSupplier_i* ProxyPushSupplierImpl_ptr;

class ProxyPushSupplier_i :
  virtual public CosEventComm::_sk_PushSupplier,
  virtual public CosEventChannelAdmin::_sk_ProxyPushSupplier {

public:
    ProxyPushSupplier_i (EventChannel_i* impl);
    ~ProxyPushSupplier_i();
    void connect_push_consumer (CosEventComm::PushConsumer_ptr push_consumer);
    void disconnect_push_supplier ();

private:
    void addEvent (const event_t &event);
    friend class EventChannel_i;

private:
    void _dispatch(void);
    stamp_t                        _stamp;
    omni_mutex                     _lock;
    omni_mutex                     _headLock;
    omni_thread                   *_dispatcher;
    omni_condition                 _nonEmpty;
    list<event_t>                  _events;
    EventChannel_i                *_channel;
    CosEventComm::PushConsumer_ptr _consumer;
    enum {notConnected, connected, disconnected} _proxyState;
};


class ProxyPushSupplierWorker : public omni_thread {

public:
    typedef void (ProxyPushSupplier_i::*Method)(void);
    ProxyPushSupplierWorker(ProxyPushSupplier_i *object,
                            Method method,
                            priority_t priority = PRIORITY_NORMAL);
    void* run_undetached(void *);
    ~ProxyPushSupplierWorker();

private:
    ProxyPushSupplier_i* _object;
    Method _method;
    ProxyPushSupplierWorker();
};

// PULL
//------------------------------------------------------------------------
class ProxyPullSupplier_i;
typedef ProxyPullSupplier_i* ProxyPullSupplierImpl_ptr;

class ProxyPullSupplier_i :
  virtual public CosEventChannelAdmin::_sk_ProxyPullSupplier {

public:
    ProxyPullSupplier_i (EventChannel_i *impl);
    void connect_pull_consumer (CosEventComm::PullConsumer_ptr pull_consumer);
    void disconnect_pull_supplier ();
    CORBA::Any* pull ();
    CORBA::Any* try_pull (CORBA::Boolean &has_event);

private:
    void addEvent (const event_t &event);
    friend class EventChannel_i;

private:
    stamp_t                        _stamp;
    omni_mutex                     _lock;
    omni_mutex                     _headLock;
    omni_condition                 _nonEmpty;
    list<event_t>                  _events;
    EventChannel_i                 *_channel;
    CosEventComm::PullConsumer_ptr _consumer;
    enum {notConnected, connected, disconnected} _proxyState;
};


//------------------------------------------------------------------------
class ProxyPullConsumer_i;
typedef ProxyPullConsumer_i* ProxyPullConsumerImpl_ptr;

class ProxyPullConsumer_i :
  virtual public CosEventComm::_sk_PullConsumer,
  virtual public CosEventChannelAdmin::_sk_ProxyPullConsumer {

public:
    ProxyPullConsumer_i (EventChannel_i *impl);
    void connect_pull_supplier (CosEventComm::PullSupplier_ptr pull_supplier);
    void disconnect_pull_consumer ();

private:
    CORBA::Any *getEvent(CORBA::Boolean &has_event);
    friend class EventChannel_i;

private:
    omni_mutex      _lock;
    EventChannel_i* _channel;
    CosEventComm::PullSupplier_ptr _supplier;
    enum {notConnected, connected, disconnected} _proxyState;
};

//------------------------------------------------------------------------
// ADMIN

class ConsumerAdmin_i :
  public CosEventChannelAdmin::_sk_ConsumerAdmin {

public: 
    ConsumerAdmin_i (EventChannel_i *channel);
    ~ConsumerAdmin_i ();
    CosEventChannelAdmin::ProxyPushSupplier_ptr obtain_push_supplier ();
    CosEventChannelAdmin::ProxyPullSupplier_ptr obtain_pull_supplier ();

private:
    EventChannel_i* event_channel;
};

//------------------------------------------------------------------------
class SupplierAdmin_i :
  public CosEventChannelAdmin::_sk_SupplierAdmin {

public: 
    SupplierAdmin_i (EventChannel_i *channel);
    ~SupplierAdmin_i ();
    CosEventChannelAdmin::ProxyPushConsumer_ptr obtain_push_consumer ();
    CosEventChannelAdmin::ProxyPullConsumer_ptr obtain_pull_consumer ();

private:
    EventChannel_i* event_channel;
};

// EVENT CHANNEL

#if defined (__GNUC__)  || defined (__aix__) || defined (__alpha__) || defined (__sunos__)
typedef set<ProxyPushSupplier_i *,less<ProxyPushSupplier_i *> > ProxyPushSupplierSet;
typedef set<ProxyPushConsumer_i *,less<ProxyPushConsumer_i *> > ProxyPushConsumerSet;
typedef set<ProxyPullSupplier_i *,less<ProxyPullSupplier_i *> > ProxyPullSupplierSet;
typedef set<ProxyPullConsumer_i *,less<ProxyPullConsumer_i *> > ProxyPullConsumerSet;
#elif defined (__hpux__) || defined (__WIN32__) || defined (__irix__)
typedef set<ProxyPushSupplier_i *> ProxyPushSupplierSet;
typedef set<ProxyPushConsumer_i *> ProxyPushConsumerSet;
typedef set<ProxyPullSupplier_i *> ProxyPullSupplierSet;
typedef set<ProxyPullConsumer_i *> ProxyPullConsumerSet;
#elif
Note: omniEvents has not been ported to your architecture.
#endif

class EventChannel_i :
  public CosEventChannelAdmin::_sk_EventChannel {

public:
   EventChannel_i (unsigned long pullRetryPeriod = 1);
   ~EventChannel_i ();

   CosEventChannelAdmin::ConsumerAdmin_ptr for_consumers ();
   CosEventChannelAdmin::SupplierAdmin_ptr for_suppliers ();

   void destroy ();
   CORBA::Boolean _save_object ();

private:
   // Proxy Registration
   void _reg_pxy_push_consumer (ProxyPushConsumer_i *);
   void _reg_pxy_push_supplier (ProxyPushSupplier_i *);
   void _reg_pxy_pull_consumer (ProxyPullConsumer_i *);
   void _reg_pxy_pull_supplier (ProxyPullSupplier_i *);

   // Proxy De-Registration
   void _drg_pxy_push_consumer (ProxyPushConsumer_i *);
   void _drg_pxy_push_supplier (ProxyPushSupplier_i *);
   void _drg_pxy_pull_consumer (ProxyPullConsumer_i *);
   void _drg_pxy_pull_supplier (ProxyPullSupplier_i *);

   void disconnect ();

   void addEvent (const CORBA::Any &any);
   void reqEvent (void);

   friend class EventChannelWorker;
   friend class ProxyPushConsumer_i;
   friend class ProxyPullConsumer_i;
   friend class ProxyPushSupplier_i;
   friend class ProxyPullSupplier_i;

private:

   int  _empty;
   unsigned long _pullRetryPeriod;
   int agentMode(void);
   void _pull(void);
   void _dispatch(void);
   void _collect(void);
   omni_mutex _lock;
   omni_mutex _headLock;
   omni_mutex _pullLock;
   omni_mutex _collectLock;
   omni_condition *_nonEmpty;
   omni_condition *_pullEvent;
   omni_condition *_collectEvent;
   omni_thread *_agent;
   omni_thread *_dispatcher;
   omni_thread *_pullWorker;

   list<event_t> _events;

   // List of Proxies
   ProxyPushSupplierSet _pxy_push_supp;
   ProxyPushConsumerSet _pxy_push_cons;
   ProxyPullSupplierSet _pxy_pull_supp;
   ProxyPullConsumerSet _pxy_pull_cons;

   SupplierAdmin_i *supplier_admin;
   ConsumerAdmin_i *consumer_admin;
};

class EventChannelWorker : public omni_thread {

public:
   typedef void (EventChannel_i::*Method)(void);
 
public:
   EventChannelWorker(EventChannel_i &object,
                      Method method,
                      priority_t priority = PRIORITY_NORMAL);
   void run(void *);

private:
   EventChannel_i* _object;
   Method _method;
   EventChannelWorker() {};
};

// FACTORY

class EventChannelFactory_i :
  public EventChannelAdmin::_sk_EventChannelFactory {

public:
   EventChannelFactory_i ();
   CORBA::Boolean supports (const CosLifeCycle::Key &k);
   CORBA::Object_ptr create_object(const CosLifeCycle::Key &k,
                                   const CosLifeCycle::Criteria &the_criteria);
};

#endif
