include ../DEBUG.mk
include ../trilib.mk

CXXSRCS = ReadyChannel_d.cc
CXXOBJS = ReadyChannel_d.o 

# omniORB3 does not yet support long long passed in ANY values,
# hence, we need to pass the -DNOLONGLONG flag so that TimeBase::TimeT
# values can be sent to/from the channel as property values.

# X no idl to compile
# X OMNIORB_IDL_ANY_FLAGS  += -DNOLONGLONG
# X OMNIORB2_IDL_ANY_FLAGS += -DNOLONGLONG 
# X ifdef CosUsesBoa
# X we need to specify -WbBOA for omniORB3 when we use BOA
# X OMNIORB_IDL_ANY_FLAGS  += -WbBOA
# X endif

# add services/include/omniNotify
IMPORT_CPPFLAGS += $(patsubst %,-I%/src/services/include/omniNotify,$(IMPORT_TREES))

DIR_CPPFLAGS  = $(CORBA_CPPFLAGS)
DIR_CPPFLAGS += $(COS_CPPFLAGS)

notifd   = $(patsubst %,$(BinPattern),notifd)

ALL_TARGETS = $(notifd)

all::     $(ALL_TARGETS)

export:: $(ALL_TARGETS)
	@(module="as"; $(ExportExecutable))

clean::
	$(RM) $(ALL_TARGETS) *.d

$(notifd) : $(CXXOBJS) $(TRI_LIB_DEPEND)
	@(libs="$(TRI_LIB)"; $(CXXExecutable))

# STATIC BUILD:
#$(notifd) : $(CXXOBJS) $(TRI_LIB_DEPEND)
#	@(libs="$(TRI_STATIC_LIB)"; $(CXXExecutable))

