// -*- Mode: C++; -*-
//                              File      : ReadyChannel_d.cc
//                              Package   : omniNotify-daemon
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2001 AT&T Laboratories -- Research
//
//    This file is part of executable program omniNotify-daemon
//    and is distributed with the omniNotify release.
//
//    omniNotify-daemon is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//    USA.
//
// Description:
//    Implementation of the omniNotify daemon process
//
 
/*
$Log: ReadyChannel_d.cc,v $
Revision 1.63.2.2  2002/02/28 23:43:56  alcfp
merge alpha branch back into dev for latest fixes

Revision 1.63.4.3  2002/02/26 22:26:37  alcfp
changed notifd to use RDI_Interactive_Mode helper, wait_for_destroy

Revision 1.63.4.2  2002/02/20 21:17:14  alcfp
steps towards correct oref refcounts

Revision 1.63.4.1  2002/02/07 18:10:54  alcfp
merged recent dev fixes into alpha

Revision 1.63.2.1  2001/10/09 06:38:04  alcfp
11 release

Revision 1.64  2001/10/09 04:27:22  alcfp
preparing for 11 release

Revision 1.63  2001/10/06 00:41:22  alcfp
type fix

Revision 1.62  2001/10/02 14:07:49  alcfp
improved error messages for command line errors

Revision 1.61  2001/09/28 02:10:10  alcfp
oops

Revision 1.60  2001/09/27 17:31:42  alcfp
fixed target unavailable case

Revision 1.59  2001/09/27 17:20:02  alcfp
better error messages for prop combo problem

Revision 1.58  2001/09/19 21:09:59  alcfp
Added cleanup support to interactive api

Revision 1.57  2001/08/03 17:54:12  alcfp
added support for AttNotification

Revision 1.56  2001/06/26 20:01:00  alcfp
updated copyright notices, added support for omniORB4, switched default to POA

Revision 1.55  2001/06/22 07:00:19  alcfp
moved to new logging scheme

Revision 1.54  2001/06/12 17:56:21  alcfp
minor cleanup

Revision 1.53  2001/05/29 20:37:57  alcfp
larger maxtcp

Revision 1.52  2000/11/17 21:39:33  alcfp
small fixes to get rid of some Sun CC 5.0 compiler warnings

Revision 1.51  2000/11/16 04:20:34  alcfp
changes to make use of omniNotify.h and wrapper files consistent

Revision 1.50  2000/11/15 21:19:14  alcfp
changed to new corba_wrappers approach

Revision 1.49  2000/11/05 04:48:07  alcfp
changed in defaults, env variable overrride, try_pull variants

Revision 1.48  2000/10/09 19:47:20  alcfp
modified version number

Revision 1.47  2000/09/27 19:30:10  alcfp
Stopped using tcAliasExpand=1 : dynamic evaluation now uses typecode equivalence test or DynFoo narrow test rather than checking for a specific TCKind

Revision 1.46  2000/08/22 18:21:47  alcfp
getopt fix

Revision 1.45  2000/08/16 20:18:50  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#include <stdio.h>
#include <stdlib.h>
#include "corba_wrappers.h"
#include "CosNotifyShorthands.h"
#include "omniNotify.h"
#include "RDIOSWrappers.h"
#include "RDIStringDefs.h"
#include "RDIstrstream.h"
#include "RDIInteractiveMode.h"

// ----------------------------------------------------------//

int main(int argc, char** argv)
{
  CORBA::Boolean interactive = 0;
  AttN::Server_ptr server = AttN::Server::_nil();
  int indx=0;
  char* pn = argv[0];
  while (RDI_STRCHR(pn, '/')) { pn = RDI_STRCHR(pn, '/'); pn++; }
  while (RDI_STRCHR(pn, '\\')) { pn = RDI_STRCHR(pn, '\\'); pn++; }
  if (RDI_STRLEN(pn) == 0) { pn = (char*)"notifd"; }
  char* pname = CORBA_STRING_DUP(pn);

  // Increase the limit of open file descriptor to the maximum
  RDI_OS_MAX_OPEN_FILE_DESCRIPTORS;

  while ( indx < argc ) {
    if (RDI_STR_EQ(argv[indx], "-h")) {
      fprintf(stdout, "Usage: %s [-h] [-v] [-i] [-n] [-c <f>]\n", pname);
      fprintf(stdout, "   -h       : print usage information and exit\n");
      fprintf(stdout, "   -v       : print software version and exit\n");
      fprintf(stdout, "   -i       : enter interactive mode\n");
      fprintf(stdout, "   -n       : do NOT register with the NameService\n");
      fprintf(stdout, "   -c <f>   : read config file <f>\n\n");
      return 0;
    }
    if (RDI_STR_EQ(argv[indx], "-v")) {
      fprintf(stdout, "notifd:  -- omniNotify server version %s\n", OMNINOTIFY_VERSION);
      return 0;
    }
    if (RDI_STR_EQ(argv[indx], "-i")) {
      RDI_rm_arg(argc, argv, indx);
      interactive = 1;
    } else {
      indx += 1;
    }
  }

  // Configure the undelying ORB and BOA/POA before creating
  // omniNotify server instance

  // We use 1000 here because using a small # limits
  // the number of outstanding pull calls from pull consumers
  // XXX What happens with an OS that does not support this call?
  WRAPPED_ORB_SETMAXTCP(1000); 
  WRAPPED_ORB_OA::init(argc, argv);

  // initialize the server
  server = omniNotify::init_server(argc, argv);
  if (CORBA::is_nil(server)) {
    fprintf(stdout, "\nnotifd: failed to create a new omniNotify server\n");
    return -1;
  }
  WRAPPED_ORB_OA::activate_oas();
  if (interactive) {
    RDI_Interactive_Mode(server, 1); // 1 means spawn a thread
  }
  // wait for server to be destroyed
  omniNotify::wait_for_destroy();
  WRAPPED_ORB_OA::cleanup();
  CORBA_STRING_FREE(pname);
  return 0;
}

