NFYLIB_CXXSRCS = \
    corba_wrappers_impl.cc \
    RDIDebug.cc        RDITime.cc         Filter_i.cc        FilterAdmin_i.cc \
    RDITypeMap.cc      RDIFileSys.cc      RDIConfig.cc \
    RDIFileIO.cc       RDILog.cc          \
    RDIParser_y.cc     RDIParser_l.cc     RDIRVM.cc          RDIEval.cc \
    RDIStaticEval.cc   RDIDynamicEval.cc  RDIConstraint.cc   RDIOpSeq.cc  \
    ChannelAdmin_i.cc  ProxyConsumer.cc   EventChannel_i.cc \
    ProxySupplier.cc   RDIChannelUtil.cc  RDIEventQueue.cc \
    CosEventProxy.cc   CosNotification.cc omniNotify.cc      RDIOplocks.cc

# XXX CosNaming_i.cc

NFYLIB_CXXOBJS = $(NFYLIB_CXXSRCS:.cc=.o)

NFYLIB_OBJS = $(NFYLIB_CXXOBJS)

# omniidl/omniidl2 do not support long long and, hence, we need
# to pass the -DNOLONGLONG flag for TimeBase.idl.  In addition,
# we need to specify -WbBOA for omniORB3 since we still use BOA

OMNIORB_IDL_ANY_FLAGS  += -DNOLONGLONG -WbBOA
OMNIORB2_IDL_ANY_FLAGS += -DNOLONGLONG 

# add services/omniNotify/include:
IMPORT_CPPFLAGS += $(patsubst %,-I%/src/services/omniNotify/include,$(IMPORT_TREES))

DIR_CPPFLAGS  = $(CORBA_CPPFLAGS)

# -mt does not belong in CFLAGS
CFLAGS := $(patsubst -mt,,$(CFLAGS))

ifndef COSDynamicBOACompatible

vpath %.idl $(IMPORT_TREES:%=%/idl/COS)
DIR_IDLFLAGS += -I. $(patsubst %,-I%/idl/COS,$(IMPORT_TREES))
DIR_IDLFLAGS  += -Wbuse_quotes
DIR_IDLFLAGS  += -DNOLONGLONG
DIR_CPPFLAGS = $(CORBA_CPPFLAGS) -D_COS_LIBRARY 
DIR_IDLFLAGS += -WbBOA

NFYLIB_CXXSRCS += CosNotificationDynSK.cc TimeBaseDynSK.cc RDITestTypesDynSK.cc

%DynSK.cc: %.idl
	$(CORBA_IDL) $(DIR_IDLFLAGS) $^	

.PRECIOUS: %DynSK.cc

endif
