// -*- Mode: C++; -*-

#ifndef __OMNIORB3_POA_WRAPPERS_IMPL_H__
#define __OMNIORB3_POA_WRAPPERS_IMPL_H__

#include "omniorb3_poa_wrappers.h"

CORBA::ORB_ptr WRAPPED_ORB_OA::_orb = 0;
PortableServer::POA_ptr WRAPPED_ORB_OA::_poa = 0;
CORBA::Boolean WRAPPED_ORB_OA::_poa_activated = 0;

void WRAPPED_ORB_OA::init(int argc, char** argv) {
  _orb = CORBA::ORB_init(argc, argv, "omniORB3");
  CORBA::Object_var obj = orb->resolve_initial_references("RootPOA");
  _poa = PortableServer::POA::_narrow(obj);
  _poa_activated = 0;
}

void WRAPPED_ORB_OA::cleanup() {
  if (_orb) _orb->destroy();
  _poa = 0;
  _orb = 0;
  _poa_activated = 0;
}

void WRAPPED_ORB_OA::activate_oas() {
  if (!_poa_activated) {
    PortableServer::POAManager_var pman = _poa->the_POAManager();
    pman->activate();
    _poa_activated = 1;
  }
}

void WRAPPED_ORB_OA::run() {
  activate_oas();
  _orb->run();
}

void WRAPPED_ORB_OA::shutdown(CORBA::Boolean wait_for_completion) {
  _orb->shutdown(wait_for_completion);
}


#endif
