// -*- Mode: C++; -*-
//                              File      : RDITimeMacros.h
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    proprietary interface
//
 
/*
$Log: RDITimeMacros.h,v $
Revision 1.6  2000/08/22 18:23:51  alcfp
added description to each file

Revision 1.5  2000/08/16 20:19:20  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#ifndef __RDI_TIME_MACROS_H__
#define __RDI_TIME_MACROS_H__

#include "omnithread.h"

#define RDI_NS2US(x) ((x) / 1000)
#define RDI_NS2MS(x) ((x) / 1000000)

#define RDI_US2MS(x) ((x) / 1000)
#define RDI_US2S(x)  ((x) / 1000000)

#define RDI_SC2MS(x) ((x) * 1000)
#define RDI_SC2US(x) ((x) * 1000000)
#define RDI_SC2NS(x) ((x) * 1000000000)

#define RDI_TIMEDIFF_MSECS(start_tval_s,start_tval_n,end_tval_s,end_tval_n)\
  ( (end_tval_n > start_tval_n) ? \
    (RDI_SC2MS(end_tval_s - start_tval_s) + \
     RDI_NS2MS(end_tval_n - start_tval_n)) : \
    (RDI_SC2MS(end_tval_s - start_tval_s - 1) + \
     RDI_NS2MS((RDI_SC2NS(1) + end_tval_n) - start_tval_n)))

#define RDI_TIMEDIFF_USECS(start_tval_s,start_tval_n,end_tval_s,end_tval_n)\
  ( (end_tval_n > start_tval_n) ? \
    (RDI_SC2US(end_tval_s - start_tval_s) + \
     RDI_NS2US(end_tval_n - start_tval_n)) : \
    (RDI_SC2US(end_tval_s - start_tval_s - 1) + \
     RDI_NS2US((RDI_SC2NS(1) + end_tval_n) - start_tval_n)))

#define WASTE_SOME_MSECS(m, verbose) if (m) do {\
  unsigned long _start_s, _start_n, _end_s, _end_n;\
  omni_thread::get_time(&_start_s, &_start_n);\
  do {\
    for (unsigned long i=1; i < 10000; i++) {\
    }\
    omni_thread::get_time(&_end_s, &_end_n);\
    if (verbose) {\
      cout << "Wasted " << RDI_TIMEDIFF_MSECS(_start_s,_start_n,_end_s,_end_n) << " milliseconds" << endl;\
    }\
  } while (RDI_TIMEDIFF_MSECS(_start_s,_start_n,_end_s,_end_n) < ((unsigned long)m));\
} while (0)

#define WASTE_SOME_USECS(u, verbose) if (u) do {\
  unsigned long _start_s, _start_n, _end_s, _end_n;\
  omni_thread::get_time(&_start_s, &_start_n);\
  do {\
    for (unsigned long i=1; i < 1000; i++) {\
    }\
    omni_thread::get_time(&_end_s, &_end_n);\
    if (verbose) {\
      cout << "Wasted " << RDI_TIMEDIFF_USECS(_start_s,_start_n,_end_s,_end_n) << " microseconds" << endl;\
    }\
  } while (RDI_TIMEDIFF_USECS(_start_s,_start_n,_end_s,_end_n) < ((unsigned long)u));\
} while (0)

#endif

