// -*- Mode: C++; -*-
//                              File      : RDITimeDefs.h
//                              Package   : omniNotify-Library
//                              Created on: 19-Oct-2000
//                              Authors   : gruber
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    proprietary interface
//
 
/*
$Log: RDITimeDefs.h,v $
Revision 1.3  2000/11/05 04:48:09  alcfp
changed in defaults, env variable overrride, try_pull variants

Revision 1.2  2000/10/30 05:41:45  alcfp
renamed CosNotify.h to CosNotifyShorthands.h and placed CosNotifyShorthands.h in omniNotify/include rather than src/services/include

Revision 1.1  2000/10/30 04:39:24  alcfp
extensive changes in preparation for 1.1 release.  will add notes about changes to update.log

*/
 
#ifndef _RDI_TIMEDEFS_H_
#define _RDI_TIMEDEFS_H_

#include <limits.h>
#include "CosNotifyShorthands.h"
#include "RDIDebug.h"


// For TimeBase::TimeT conversion, TimeT is in units of 100 ns

inline void RDI_Millisec2SecNanosec(const unsigned long msec, unsigned long& t_s, unsigned long& t_n) {
  t_s = msec / 1000;
  t_n = (msec % 1000) * 1000000;
}

inline void RDI_TimeT2SecNanosec(const TimeBase::TimeT& t, unsigned long& t_s, unsigned long& t_n) {
  if (t.high)
    RDI_DUMP("** WARNING: high part of TimeT ignored for now!! **");
  unsigned long t_low = (unsigned long)(t.low);
  t_s = t_low / 10000000;
  t_n = (t_low % 10000000) * 100;
}

inline void RDI_SecNanosec2TimeT(const unsigned long t_s, const unsigned long t_n, TimeBase::TimeT& t) {
  t.high = 0;
  if (t_s > (ULONG_MAX / 10000000)) {
    RDI_DUMP("** WARNING: high part of TimeT ignored for now!! **");
    t.low = ULONG_MAX;
    return;
  }
  t.low = t_s * 10000000;
  if (t.low > (ULONG_MAX - (t_n / 100)) ) {
    RDI_DUMP("** WARNING: high part of TimeT ignored for now!! **");
    t.low = ULONG_MAX;
    return;
  }
  t.low += (t_n / 100);
}

// milliseconds * 1,000,000 = nanoseconds
// ergo, use * 10,000 to get units of 100 nanoseconds
inline void RDI_Millisec2TimeT(const unsigned long msec, TimeBase::TimeT& t) {
  t.high = 0;
  if (msec > (ULONG_MAX / 10000)) {
    RDI_DUMP("** WARNING: high part of TimeT ignored for now!! **");
    t.low = ULONG_MAX;
    return;
  }
  t.low = msec * 10000;
}

#endif
