// -*- Mode: C++; -*-
//                              File      : RDI.h
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    proprietary interface
//
 
/*
$Log: RDI.h,v $
Revision 1.10  2000/11/15 21:18:17  alcfp
large number of changes to switch to use of RDIOplocks for safe object disposal support.  also reduced code duplication a little, and tried hard to make all the proxy code consistent

Revision 1.9  2000/08/22 18:23:48  alcfp
added description to each file

Revision 1.8  2000/08/16 20:19:04  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#ifndef __RDI_H__
#define __RDI_H__

// STATIC CONFIGURATION DEFNS -- 
//   can be overridden with -D<name>=<value> compiler flag

// RDI_LOCK_EVENT controls whether event state is locked during matching.
// We believe this is probably necessary given that the current omniORB
// implementation of DynAny is not thread safe.  With a thread-safe
// DynAny, it might be OK to set this value to zero.

#ifndef RDI_LOCK_EVENT
#  define RDI_LOCK_EVENT 1
#endif

// now add a cast to get typing right
#if RDI_LOCK_EVENT == 1
#  undef RDI_LOCK_EVENT
#  define RDI_LOCK_EVENT (CORBA::Boolean)1
#else
#  undef RDI_LOCK_EVENT
#  define RDI_LOCK_EVENT (CORBA::Boolean)0
#endif

#endif /* __RDI_H__  */

