include ../DEBUG.mk
include libdefs.mk
include ../trilib.mk

DIR_CPPFLAGS += $(COS_CPPFLAGS)

ifeq ($(platform),sun4_sosV_5.5)
DIR_CPPFLAGS += -D__SOSV_MINOR_VER__=55
endif

NFYLIB_NAME    = COSNotify$(COS_OA)

CXXSRCS = $(NFYLIB_CXXSRCS)
CSRCS = $(NFYLIB_CSRCS)

all:: export_useful
all:: mkstatic mkshared

export:: export_useful
export:: mkstatic mkshared

# export the library include file to <omni_top>/include
export_useful:: ../include/omniNotify.h
	@(for i in $^; do \
            file="$$i"; \
            dir="$(EXPORT_TREE)/$(INCDIR)"; \
		$(ExportFileToDir) \
          done )

# export .h files useful for writing omniNotify client programs
# to <omni_top>/src/services/include/omniNotify
export_useful:: ../include/CosNotifyShorthands.h ../include/corba_wrappers.h ../include/corba_wrappers_impl.h ../include/omniorb3_boa_wrappers.h ../include/omniorb3_poa_wrappers.h ../include/omniorb3_boa_wrappers_impl.h ../include/omniorb3_poa_wrappers_impl.h
	@(for i in $^; do \
            file="$$i"; \
            dir="$(EXPORT_TREE)/src/services/include/omniNotify"; \
		$(ExportFileToDir) \
          done )

##############################################################################
# Build Static library
##############################################################################

version  := $(word 1,$(subst ., ,$(OMNIORB_VERSION)))

sk = static/$(patsubst %,$(LibNoDebugPattern),$(NFYLIB_NAME)$(version))

mkstatic::
	@(dir=static; $(CreateDir))

mkstatic:: $(sk)

$(sk): $(patsubst %, static/%, $(NFYLIB_OBJS))
	@$(StaticLinkLibrary)

export:: $(sk)
	@$(ExportLibrary)

clean::
	$(RM) static/*.o
	$(RM) $(sk)

##############################################################################
# Build Shared library
##############################################################################
ifdef BuildSharedLibrary

sharedversion = $(OMNIORB_VERSION)

sknamespec    = $(subst ., ,$(NFYLIB_NAME).$(sharedversion))
skshared      = shared/$(shell $(SharedLibraryFullName) $(sknamespec))

mkshared::
	@(dir=shared; $(CreateDir))

mkshared:: $(skshared)

$(skshared): $(patsubst %, shared/%, $(NFYLIB_OBJS))
	@(namespec="$(sknamespec)" extralibs="$(OMNIORB_LIB)"; \
         $(MakeCXXSharedLibrary))

export:: $(skshared)
	@(namespec="$(sknamespec)"; \
         $(ExportSharedLibrary))

clean::
	$(RM) shared/*.o
	(dir=shared; $(CleanSharedLibrary))

endif

##############################################################################
# Build debug libraries for Win32
##############################################################################
ifdef Win32Platform

all:: mkstaticdbug mkshareddbug

export:: mkstaticdbug mkshareddbug

#####################################################
#      Static debug libraries
#####################################################
dbugversion = $(word 1,$(subst ., ,$(OMNIORB_VERSION)))

skdbug = debug/$(patsubst %,$(LibDebugPattern),$(NFYLIB_NAME)$(dbugversion))

mkstaticdbug::
	@(dir=debug; $(CreateDir))

mkstaticdbug:: $(skdbug)

$(skdbug): $(patsubst %, debug/%, $(NFYLIB_OBJS))
	@$(StaticLinkLibrary)

export:: $(skdbug)
	@$(ExportLibrary)

clean::
	$(RM) debug/*.o
	$(RM) $(skdbug)

#####################################################
#      DLL debug libraries
#####################################################
shareddbugversion = $(OMNIORB_VERSION)

sknamespec      = $(subst ., ,$(NFYLIB_NAME).$(shareddbugversion))
skshareddbug    = shareddebug/$(shell $(SharedLibraryDebugFullName) $(sknamespec))


mkshareddbug::
	@(dir=shareddebug; $(CreateDir))

mkshareddbug:: $(skshareddbug)

$(skshareddbug): $(patsubst %, shareddebug/%, $(NFYLIB_OBJS))
	(namespec="$(sknamespec)" debug=1 extralibs="$(OMNIORB_LIB)"; \
         $(MakeCXXSharedLibrary))

export:: $(skshareddbug)
	@(namespec="$(sknamespec)" debug=1; \
         $(ExportSharedLibrary))

clean::
	$(RM) shareddebug/*.o
	@(dir=shareddebug; $(CleanSharedLibrary))

endif

