// -*- Mode: C++; -*-

#ifndef __OMNIORB3_POA_WRAPPERS_H__
#define __OMNIORB3_POA_WRAPPERS_H__

// See comments in corba_wrappers.h

#include <iostream.h>

#ifndef __WRAPPED_NULL_STMT
#define __WRAPPED_NULL_STMT 	if (0) { }
#endif

#include <omniORB3/CORBA.h>
#include <omniORB3/Naming.hh>

class WRAPPED_ORB_OA {
public:
  static void init(int argc, char** argv);
  static void cleanup();
  static void activate_oas();
  static void run();
  static void shutdown(CORBA::Boolean wait_for_completion);
  // the approved way to access the ORB reference:
  static CORA::ORB_ptr orb() { return _orb; }
  // this state is public but should not be used except indirectly
  // by using the wrapper macros
  // (it is public so that the macros can access it)
  static CORBA::ORB_ptr          _orb;
  static PortableServer::POA_ptr _poa;
  static CORBA::Boolean          _poa_activated;
};

#define WRAPPED_ORB_SETMAXTCP(x) \
  omniORB::maxTcpConnectionPerServer = x

// With refcounting POA, using _remove_ref enables POA cleanup of servant
// #define WRAPPED_REGISTER_OBJECT(implref) \
//   if (1) { WRAPPED_ORB_OA::_poa->activate_object(implref); implref->_remove_ref(); } 
// ... but we are not using refcounting POA
#define WRAPPED_REGISTER_IMPL(implref) \
  WRAPPED_ORB_OA::_poa->activate_object(implref)

#define WRAPPED_IMPL2OREF(interfaceClass, implref) \
  interfaceClass::_duplicate(implref->_this())

#define WRAPPED_RELEASE_IMPL(implref)\
  CORBA::release(implref->_this())

#define WRAPPED_DISPOSEINFO_VAR \
  PortableServer::ObjectId_var

#define WRAPPED_DISPOSEINFO_PTR \
  PortableServer::ObjectId_ptr

#define WRAPPED_DISPOSEINFO_NIL \
  PortableServer::ObjectId::_nil()

#define WRAPPED_IMPL2DISPOSEINFO(implref) \
  WRAPPED_ORB_OA::_poa->servant_to_id(implref)

#define WRAPPED_DISPOSE_INFO(info) \
  WRAPPED_ORB_OA::_poa->deactivate_object(info)

// We do not inherit from reference counting mixin class
// because it is not portable across use of boa-based orbs.
// See how we use RDIOplocks.h/.cc for a portable solution. 

#define WRAPPED_SKELETON_SUPER(prefix, interfacenm) \
  public POA_ ## prefix ## interfacenm

#define WRAPPED_OUTARG_TYPE(T)  T ## _out
#define WRAPPED_DECLARG
#define WRAPPED_DECLARG_VOID    void
#define WRAPPED_IMPLARG
#define WRAPPED_IMPLARG_VOID    void

#define WRAPPED_RESOLVE_INITIAL_REFERENCES(nm) \
  WRAPPED_ORB_OA::_orb->resolve_initial_references(nm)

#endif
