// -*- Mode: C++; -*-

#ifndef __OMNIORB3_BOA_WRAPPERS_H__
#define __OMNIORB3_BOA_WRAPPERS_H__

// See comments in corba_wrappers.h

#include <iostream.h>

#ifndef __WRAPPED_NULL_STMT
#define __WRAPPED_NULL_STMT 	if (0) { }
#endif

#include <omniORB3/CORBA.h>
#include <omniORB3/Naming.hh>

class WRAPPED_ORB_OA {
public:
  static void init(int argc, char** argv);
  static void cleanup();
  static void activate_oas();
  static void run();
  static void shutdown(CORBA::Boolean wait_for_completion);
  // the approved way to access the ORB reference:
  static CORBA::ORB_ptr orb() { return _orb; }
  // this state is public but should not be used except indirectly
  // by using the wrapper macros
  // (it is public so that the macros can access it)
  static CORBA::ORB_ptr _orb;
  static CORBA::BOA_ptr _boa;
  static CORBA::Boolean _invoked_impl_is_ready;
};

#define WRAPPED_ORB_SETMAXTCP(x) \
  omniORB::maxTcpConnectionPerServer = x

#define WRAPPED_REGISTER_IMPL(implref) \
  implref->_obj_is_ready(WRAPPED_ORB_OA::_boa)

#define WRAPPED_IMPL2OREF(interfaceClass, implref) \
  interfaceClass::_duplicate(implref->_this())

#define WRAPPED_RELEASE_IMPL(implref)\
  CORBA::release(implref->_this())

#define WRAPPED_DISPOSEINFO_VAR \
  CORBA::Object_var

#define WRAPPED_DISPOSEINFO_PTR \
  CORBA::Object_ptr

#define WRAPPED_DISPOSEINFO_NIL \
  CORBA::Object::_nil()

#define WRAPPED_IMPL2DISPOSEINFO(implref) \
  implref->_this()

#define WRAPPED_DISPOSE_INFO(info) \
  WRAPPED_ORB_OA::_boa->dispose(info)

#define WRAPPED_SKELETON_SUPER(prefix, interfacenm) \
  public virtual  prefix ## _sk_ ## interfacenm

#define WRAPPED_OUTARG_TYPE(T)  T ## _out
#define WRAPPED_DECLARG
#define WRAPPED_DECLARG_VOID    void
#define WRAPPED_IMPLARG
#define WRAPPED_IMPLARG_VOID    void

#define WRAPPED_RESOLVE_INITIAL_REFERENCES(nm) \
  WRAPPED_ORB_OA::_orb->resolve_initial_references(nm)

#endif
