# Like cos.mk with these additions:
#
# Provides NFY_LIB, NFY_LIB_DEPEND
#
# Also provides combinations:
#     BOTH_LIB* = COS_LIB* + CORBA_LIB*
#     TRI_LIB*  = NFY_LIB* + BOTH_LIB*
#
# To use the COS idls in application IDLs
#   DIR_IDLFLAGS += $(COS_IDLFLAGS)
#
# To compile the application stubs:
#   DIR_CPPFLAGS += $(COS_CPPFLAGS)

CosUsesBoa = 1
include $(BASE_OMNI_TREE)/mk/cos.mk

ifndef Win32Platform

nfy_libname        = COSNotify$(COS_OA)$(word 1,$(subst ., ,$(COS_VERSION)))
NFY_LIB    = $(patsubst %,$(LibSearchPattern),$(nfy_libname))

nfylib     = $(patsubst %,$(LibPattern),$(nfy_libname))
lib_depend := $(nfylib)
NFY_LIB_DEPEND := $(GENERATE_LIB_DEPEND)

else

ifndef BuildDebugBinary

nfy_dlln := $(shell $(SharedLibraryFullName) $(subst ., ,COSNotify$(COS_OA).$(COS_VERSION)))

else

nfy_dlln := $(shell $(SharedLibraryDebugFullName) $(subst ., ,COSNotify$(COS_OA).$(COS_VERSION)))

endif

NFY_LIB     = $(nfy_dlln)

lib_depend := $(nfy_dlln)
NFY_LIB_DEPEND := $(GENERATE_LIB_DEPEND)

endif

ifdef COSDynamicBOACompatible
BOTH_LIB        = $(COS_LIB)
BOTH_LIB_DEPEND = $(COS_LIB_DEPEND)
else
BOTH_LIB        = $(COS_LIB_NODYN)
BOTH_LIB_DEPEND = $(COS_LIB_NODYN_DEPEND)
endif

BOTH_LIB        += $(CORBA_LIB)       
BOTH_LIB_DEPEND += $(CORBA_LIB_DEPEND)

TRI_LIB         = $(NFY_LIB)          $(BOTH_LIB)
TRI_LIB_DEPEND  = $(NFY_LIB_DEPEND)   $(BOTH_LIB_DEPEND)

# XXX only works for unix platforms?
BOTH_STATIC_LIB = $(BOTH_LIB_DEPEND)
BOTH_STATIC_LIB += $(OMNITHREAD_LIB) $(SOCKET_LIB)

TRI_STATIC_LIB  = $(TRI_LIB_DEPEND)
TRI_STATIC_LIB += $(OMNITHREAD_LIB) $(SOCKET_LIB)


