// -*- Mode: C++; -*-

#ifndef __OMNIORB3_BOA_WRAPPERS_IMPL_H__
#define __OMNIORB3_BOA_WRAPPERS_IMPL_H__

#include "omniorb3_boa_wrappers.h"

CORBA::ORB_ptr WRAPPED_ORB_OA::_orb = 0;
CORBA::BOA_ptr WRAPPED_ORB_OA::_boa = 0;
CORBA::Boolean WRAPPED_ORB_OA::_invoked_impl_is_ready = 0;

void WRAPPED_ORB_OA::init(int argc, char** argv) {
  _orb = CORBA::ORB_init(argc, argv, "omniORB3");
  _boa = _orb->BOA_init(argc,argv,"omniORB3_BOA");
  _invoked_impl_is_ready = 0;
}

void WRAPPED_ORB_OA::cleanup() {
  if (_boa) _boa->destroy();
  if (_orb) _orb->destroy();
  _boa = 0;
  _orb = 0;
  _invoked_impl_is_ready = 0;
}

void WRAPPED_ORB_OA::activate_oas() {
  if (!_invoked_impl_is_ready) {
    _boa->impl_is_ready(0,1);
    _invoked_impl_is_ready = 1;
  }
}

void WRAPPED_ORB_OA::run() {
  activate_oas();
  _orb->run();
}

void WRAPPED_ORB_OA::shutdown(CORBA::Boolean wait_for_completion) {
  _orb->shutdown(wait_for_completion);
}


#endif
