// -*- Mode: C++; -*-
//                              File      : omniNotify.cc
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2001 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    Implementation of omniNotify [main library interface]
//
 
/*
$Log: omniNotify.cc,v $
Revision 1.15  2001/10/02 14:07:53  alcfp
improved error messages for command line errors

Revision 1.14  2001/08/03 17:54:19  alcfp
added support for AttNotification

Revision 1.13  2001/06/26 20:01:22  alcfp
updated copyright notices, added support for omniORB4, switched default to POA

Revision 1.12  2001/06/22 07:00:40  alcfp
moved to new logging scheme

Revision 1.11  2001/06/12 17:54:37  alcfp
update for RDITimeWrappers

Revision 1.10  2001/05/07 16:15:11  alcfp
+ Added support for OrderPolicy and DiscardPolicy
+ Took some initial steps towards new time value handling approach
+ Took some initial steps towards a new logging approach
+ Factored out common code in proxy add_event handling

Revision 1.9  2001/03/20 22:33:32  alcfp
Moved dump_stats to separate file Stats.cc

Revision 1.8  2000/12/14 18:35:43  alcfp
fixes in channel shutdown sequence

Revision 1.7  2000/11/16 04:20:35  alcfp
changes to make use of omniNotify.h and wrapper files consistent

Revision 1.6  2000/11/15 21:17:30  alcfp
large number of changes to switch to use of RDIOplocks for safe object disposal support.  also reduced code duplication a little, and tried hard to make all the proxy code consistent

Revision 1.5  2000/11/05 04:48:12  alcfp
changed in defaults, env variable overrride, try_pull variants

Revision 1.4  2000/10/30 04:42:04  alcfp
extensive changes in preparation for 1.1 release.  will add notes about changes to update.log

Revision 1.3.4.1  2000/10/12 20:50:02  alcfp
Minor bug in scoping of an object reference variable that (sometimes) caused a null IOR to be installed in name service rather than the default channel IOR.   Fixed the scope.

Revision 1.3  2000/08/22 18:22:03  alcfp
getopt fix

Revision 1.2  2000/08/16 20:20:12  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/

#include "omniNotify.h"
#include "RDI.h"

// Just map the calls onto the real RDI calls

AttNotification::Server_ptr omniNotify::init_server(int& argc, char** argv) {
  return RDI::init_server(argc, argv);
};

AttNotification::Server_ptr omniNotify::get_server() {
  return RDI::get_server();
};

